package com.marketingconfort.adanev.vsn.document.models;

import com.marketingconfort.adanev.vsn.core.models.BaseEntity;
import jakarta.persistence.*;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import java.util.ArrayList;
import java.util.List;

@Entity
@Table(name = "folders")
@Getter
@Setter
@NoArgsConstructor
@AllArgsConstructor
public class Folder extends BaseEntity {

    @Column(nullable = false)
    private String name;

    // Self-referencing relationship for parent-child folders
    @ManyToOne(fetch = FetchType.LAZY)
    @JoinColumn(name = "parent_id")
    private Folder parent;

    @JoinColumn(name = "owner_id")
    private Long ownerId;

    @Column(nullable = false)
    private boolean favorite = false;

    @OneToMany(mappedBy = "parent")
    private List<Folder> subFolders = new ArrayList<>();
    // Relationship with Document
    @OneToMany(mappedBy = "folder")
    private List<Document> documents = new ArrayList<>();
    //If the folder shared with any user , the id should be stored here :
    @ElementCollection
    @CollectionTable(name = "folder_shared_with", joinColumns = @JoinColumn(name = "folder_id"))
    @Column(name = "user_id")
    private List<Long> sharedWith = new ArrayList<>();
}