package com.marketingconfort.adanev.vsn.fleet.models;

import com.marketingconfort.adanev.vsn.fleet.enums.AccesLevel;
import com.marketingconfort.adanev.vsn.fleet.enums.FileType;
import com.marketingconfort.adanev.vsn.fleet.enums.Visibility;
import jakarta.persistence.*;
import lombok.Data;

import java.time.LocalDateTime;

@Entity
@Data
@MappedSuperclass
public abstract class FleetFile {

    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Long id;
    private String name;
    private String documentNumber;
    private String importedBy ;
    private LocalDateTime importDate;
    private LocalDateTime expiredDate;
    @Enumerated(EnumType.STRING)
    private FileType fileType;
    @Enumerated(EnumType.STRING)
    private Visibility visibility;
    @Enumerated(EnumType.STRING)
    private AccesLevel permissions;
    private String path;

}
