package com.marketingconfort.adanev.vsn.fleet.models;

import com.marketingconfort.adanev.vsn.fleet.enums.FuelCostType;
import jakarta.persistence.*;
import lombok.Data;

import java.time.LocalDateTime;

@Entity
@Data
public class FuelCost {

    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Long id;

    private Long refNumber ;
    private Long driverId ;
    private LocalDateTime date ;

    @Enumerated(EnumType.STRING)
    private FuelCostType type ;

    @ManyToOne
    @JoinColumn(name = "supplier_fuel_type_id")
    private SupplierFuelType suppliertype;

    private Double  kmCounter ;
    private Double kmTraveled ;
    private Long departementId ;
    private Double fuelVolume ;
    private Double  totalAmount ;
    private Double unitPrice ;
    private Boolean isActive ;
    private Boolean isNormal;
    private Boolean isSendMail;
    private Boolean isJustified;
    private String observation ;
    private String causes;
    private boolean isManaged;
}
