package com.marketingconfort.adanev.vsn.fleet.models;

import jakarta.persistence.*;
import lombok.Data;

import java.time.LocalDateTime;

@Entity
@Data
@Table(name="geoloc-data")
public class GeolocData{

    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Long id;

    private LocalDateTime startDate;
    private LocalDateTime endDate;
    private Double abnormalMileage ;
    private Long departementId;
    private Double distance;
    private String departureAddress;
    private String arrivalAddress;
    private boolean isNormal;
    private boolean isJustified;
    private boolean isSendMail;
    private String observation;
    private String causes;
    private String departureLocation;
    private String arrivalLocation;
    private boolean isManaged;
    private Long driverId;

    @ManyToOne
    @JoinColumn(name = "vehicle_id")
    private Vehicle vehicle;

    @ManyToOne
    @JoinColumn(name = "supplier_fuel_type_id")
    private SupplierFuelType supplierFuelType;
}
