package com.marketingconfort.adanev.vsn.fleet.models;

import com.marketingconfort.adanev.vsn.fleet.enums.DeclarationType;
import com.marketingconfort.adanev.vsn.fleet.enums.IncidentStatus;
import jakarta.persistence.*;
import lombok.Data;

import java.time.LocalDateTime;
import java.util.List;

@Entity
@Data
public class Incident{

    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Long id;

    private Long refNumber ;
    private Long driverId ;
    private LocalDateTime date ;
    private LocalDateTime startDate ;
    private LocalDateTime endDate ;

    @Enumerated(EnumType.STRING)
    private IncidentStatus status;

    @Enumerated(EnumType.STRING)
    private DeclarationType declarationType;

    @ManyToOne
    @JoinColumn(name = "vehicle_id")
    private Vehicle vehicle   ;

    @ManyToOne
    @JoinColumn(name = "incident_type_id")
    private IncidentType type  ;

    private Long assignmentId ;
    private Double  amount ;
    private Boolean isActive ;
    private Boolean constat;
    private String observation ;
    private String caseNumber;

    @OneToMany(mappedBy = "incident", cascade = CascadeType.ALL)
    private List<IncidentFleetFile> incidentFiles;
}
