package com.marketingconfort.adanev.vsn.fleet.models;

import com.marketingconfort.adanev.vsn.fleet.enums.RepairStatus;
import jakarta.persistence.*;
import lombok.Data;

import java.time.LocalDateTime;
import java.util.List;

@Entity
@Data
public class Repair{

    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Long id;

    private Long driverId;
    private Long refNumber ;
    private Long mileage;
    private LocalDateTime date ;
    private LocalDateTime startDate ;
    private LocalDateTime endDate ;

    @Enumerated(EnumType.STRING)
    private RepairStatus status;

    @ManyToOne
    @JoinColumn(name = "vehicle_id")
    private Vehicle vehicle ;

    @ManyToOne
    @JoinColumn(name = "repair_type")
    private RepairType type  ;
    private Double  costHT;
    private Double  costTTC;
    private Boolean isAccepted;
    private Boolean underWarranty;
    private String observation ;
    private String supplier;
    private String repairer;
    @OneToMany(mappedBy = "incident", cascade = CascadeType.ALL)
    private List<FleetFile> fleetFiles;

    @OneToMany(mappedBy = "repair", cascade = CascadeType.ALL)
    private List<RepairFleetFile> repairFiles;
}
