package com.marketingconfort.adanev.vsn.fleet.models;

import com.marketingconfort.adanev.vsn.fleet.enums.FuelCostType;
import jakarta.persistence.*;
import lombok.Data;

import java.util.List;

@Entity
@Data
@Table(name="supplier_fuel_type")
public class SupplierFuelType extends Type {

    @Enumerated(EnumType.STRING)
    private FuelCostType fuelType;

    @OneToMany(mappedBy = "supplierFuelType")
    private List<GeolocData> mileages ;

    @OneToMany(mappedBy = "supplierFuelType")
    private List<FuelCost> fuelCosts;
}
