package com.marketingconfort.adanev.vsn.fleet.models;

import com.marketingconfort.adanev.vsn.fleet.enums.VehicleStatus;
import jakarta.persistence.*;
import lombok.Data;

import java.time.LocalDateTime;
import java.util.List;

@Entity
@Data
@Table(name = "vehicle")
public class Vehicle {

    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Long id;

    private Long contractId;
    private String registration;
    private LocalDateTime registrationDate;

    @Enumerated(EnumType.STRING)
    private VehicleStatus status;

    private boolean isArchived;
    private boolean  isActive;
    private Long departementId;
    private Long seatCount;
    private Long wheelchairSeats;
    private String geolocalosationCode;

    @ManyToOne
    @JoinColumn(name = "vehicle_type_id")
    private VehicleType type;
    @ManyToOne
    @JoinColumn(name = "vehicle_brand_id")
    private VehicleBrand brand;

    @OneToMany(mappedBy = "vehicle", cascade = CascadeType.ALL)
    private List<Assignment> assignments;

    @OneToMany(mappedBy = "vehicle", cascade = CascadeType.ALL)
    private List<Incident > incidents;

    @OneToMany(mappedBy = "vehicle", cascade = CascadeType.ALL)
    private List<Repair> repairs;
    @OneToMany(mappedBy = "vehicle", cascade = CascadeType.ALL)
    private List<VehicleFleetFile> vehicleFiles;
    @OneToMany(mappedBy = "vehicle", cascade = CascadeType.ALL)
    private List<GeolocData> geolocData;
}


