package com.marketingconfort.adanev.vsn.geolocation.models;


import jakarta.persistence.*;
import lombok.Getter;
import lombok.Setter;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;

@Entity
@Getter
@Setter
@Table(name="geoloc_data")
public class GeolocData {

    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Long id;
    private Long deviceId;
    private String carRegistration;
    private LocalDate tripDate;
    private Long driverId;
    private String driverName;
    private Boolean isNormal;
    private String causes;
    private Boolean isManaged;
    private Boolean isSendMail;
    private String observation;

    @OneToMany(mappedBy = "geolocData", cascade = CascadeType.ALL, orphanRemoval = true)
    private List<GeolocTrip> trips = new ArrayList<>();
}
