package com.marketingconfort.adanev.vsn.geolocation.models;

import jakarta.persistence.*;
import lombok.Getter;
import lombok.Setter;

import java.time.LocalTime;
import java.util.ArrayList;
import java.util.List;

@Entity
@Getter
@Setter
@Table(name="geoloc_trip")
public class GeolocTrip {
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Long id;
    private double duration;
    private double distance;

    private LocalTime startHour;
    private LocalTime endHour;
    private double avgSpeed;

    private String departureAddress;
    private String arrivalAddress;

    @ManyToOne
    @JoinColumn(name = "geoloc_data_id")
    private GeolocData geolocData;

    @OneToMany(mappedBy = "geolocTrip", cascade = CascadeType.ALL, orphanRemoval = true)
    private List<GeolocPoint> geolocPoints = new ArrayList<>();
}
