package com.marketingconfort.adanev.vsn.hr.recruitment.form.models;

import com.marketingconfort.adanev.vsn.hr.recruitment.form.enums.FieldType;
import jakarta.persistence.*;
import lombok.*;
import java.util.ArrayList;
import java.util.List;

@Entity
@Table(name = "field")
@Data
@AllArgsConstructor
@NoArgsConstructor
public class Field {

    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Long id;

    @ManyToOne(fetch = FetchType.LAZY)
    @JoinColumn(name = "form_id", nullable = false)
    @ToString.Exclude
    private Form form;

    @Enumerated(EnumType.STRING)
    @Column(nullable = false)
    private FieldType type;

    @Column(nullable = false)
    private String label;

    private String placeholder;

    @Column(nullable = false)
    private boolean isRequired;

    @OneToMany(mappedBy = "field", cascade = CascadeType.ALL, orphanRemoval = true)
    @ToString.Exclude
    private List<FieldOption> options = new ArrayList<>();

    public void addOption(FieldOption option) {
        options.add(option);
        option.setField(this);
    }
}
