package com.marketingconfort.adanev.vsn.hr.recruitment.form.models;

import jakarta.persistence.*;
import lombok.*;

@Entity
@Table(name = "field_option")
@Data
@AllArgsConstructor
@NoArgsConstructor
public class FieldOption {

    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Long id;

    @ManyToOne(fetch = FetchType.LAZY)
    @JoinColumn(name = "field_id", nullable = false)
    @ToString.Exclude
    private Field field;

    @Column(nullable = false)
    private String value;

    @Column(nullable = false)
    private String label;
}
