package com.marketingconfort.adanev.vsn.roadMap.models.Combination;

import com.fasterxml.jackson.annotation.JsonManagedReference;
import jakarta.persistence.*;
import lombok.*;

import java.time.LocalDateTime;
import java.util.List;

@Entity
@Getter
@Setter
@AllArgsConstructor
@NoArgsConstructor
public class CombinedTable  {
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Long id;
    private String name;
    private LocalDateTime date;

    @OneToMany(mappedBy = "combinedTable")
    @JsonManagedReference
    private List<CombinedTableDay> combinedTableDayList;

    @Column(name = "driver_id")
    private Long driverId;
}
