package com.marketingconfort.adanev.vsn.roadMap.models.Combination;

import com.fasterxml.jackson.annotation.JsonBackReference;
import com.fasterxml.jackson.annotation.JsonManagedReference;
import com.marketingconfort.adanev.vsn.roadMap.models.TemplateDay;
import jakarta.persistence.Entity;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import lombok.*;

import java.util.List;

@Entity
@Getter
@Setter
@AllArgsConstructor
@NoArgsConstructor
public class CombinedTableDay extends TemplateDay {
    private Boolean isChecked;
    @ManyToOne
    @JoinColumn(name = "combinedTable_id")
    @JsonBackReference
    private CombinedTable combinedTable;
    @OneToMany(mappedBy = "combinedTableDay")
    @JsonManagedReference
    private List<CombinedTableRoad> combinedTableRoadList;
}
