package com.marketingconfort.adanev.vsn.roadMap.models;

import com.fasterxml.jackson.annotation.JsonManagedReference;
import jakarta.persistence.*;
import lombok.*;

import java.time.LocalDateTime;
import java.util.List;

@Entity
@Getter
@Setter
@AllArgsConstructor
@NoArgsConstructor
public class DriverRoadMap {
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Long id;
    private String name;
    private LocalDateTime date;
    private boolean isSubmitted;

    @OneToMany(mappedBy = "driverRoadMap")
    @JsonManagedReference
    private List<WorkedDay> workedDays;

    @Column(name = "driver_id")
    private Long driverId;
    private String driverName;

    @Column(name = "departement_id")
    private Long departementId;
    private String departementName;

    private Double totalHours;


}
