package com.marketingconfort.adanev.vsn.roadMap.models;

import com.fasterxml.jackson.annotation.JsonBackReference;
import com.marketingconfort.adanev.vsn.roadMap.enums.OtherTripType;
import com.marketingconfort.adanev.vsn.roadMap.enums.Type;
import jakarta.persistence.*;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import java.time.LocalDateTime;
import java.time.LocalTime;

@Entity
@Getter
@Setter
@AllArgsConstructor
@NoArgsConstructor
public class OtherTrip {

    @Id
    @GeneratedValue(strategy = GenerationType.SEQUENCE, generator = "other_trip_seq")
    @SequenceGenerator(name = "other_trip_seq", sequenceName = "other_trip_seq", allocationSize = 1)
    private Long id;
    @Enumerated(EnumType.STRING)
    private OtherTripType type;
    private LocalTime startHour;
    private LocalTime endHour;

    @ManyToOne
    @JoinColumn(name = "workedDay_id")
    @JsonBackReference
    private WorkedDay workedDay;
}
