package com.marketingconfort.adanev.vsn.roadMap.models;

import com.marketingconfort.adanev.vsn.roadMap.enums.PlanningType;
import jakarta.persistence.*;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import java.time.LocalDate;
import java.time.LocalTime;
import java.util.List;

@Entity
@Table(name = "planning_request")
@Getter
@Setter
@AllArgsConstructor
@NoArgsConstructor
public class PlanningRequest {

    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private long id;
    private String title;

    private String description;

    @Enumerated(EnumType.STRING)
    private PlanningType planningType;

    private LocalDate sendDate;
    private LocalDate startDate;
    private LocalDate endDate;
    private LocalTime sendTime;

    @Column(name = "agent_id", nullable = false)
    private Long agentId;
    private String agentName;

    @ElementCollection
    @CollectionTable(name = "dispatch_driver_ids", joinColumns = @JoinColumn(name = "id"))
    @Column(name = "drivers_count")
    private List<Long> driverIds;

}

