package com.marketingconfort.adanev.vsn.roadMap.models;

import com.marketingconfort.adanev.vsn.roadMap.enums.Type;
import jakarta.persistence.*;
import lombok.Getter;
import lombok.Setter;

import java.time.LocalTime;

@Entity
@Getter
@Setter
@Inheritance(strategy = InheritanceType.TABLE_PER_CLASS)
public abstract class Road {
    @Id
    @GeneratedValue(strategy = GenerationType.SEQUENCE, generator = "road_seq")
    @SequenceGenerator(name = "road_seq", sequenceName = "road_seq", allocationSize = 1)
    private Long id;
    @Enumerated(EnumType.STRING)
    private Type type;
    private LocalTime startHour;
    private LocalTime endHour;

}
