package com.marketingconfort.adanev.vsn.roadMap.models;

import jakarta.persistence.*;
import lombok.Getter;
import lombok.Setter;

import java.time.LocalDate;

@Entity
@Getter
@Setter
@Inheritance(strategy = InheritanceType.TABLE_PER_CLASS)
public abstract class TemplateDay {
    @Id
    @GeneratedValue(strategy = GenerationType.SEQUENCE, generator = "template_day_seq")
    @SequenceGenerator(name = "template_day_seq", sequenceName = "template_day_seq", allocationSize = 1)
    private Long id;
    private LocalDate date;
}
