package com.marketingconfort.adanev.vsn.roadMap.models.Validation;

import com.fasterxml.jackson.annotation.JsonBackReference;
import com.fasterxml.jackson.annotation.JsonManagedReference;
import com.marketingconfort.adanev.vsn.roadMap.models.TemplateDay;
import jakarta.persistence.*;
import lombok.*;

import java.util.List;

@Entity
@Getter
@Setter
@AllArgsConstructor
@NoArgsConstructor
public class DailyRoadMap extends TemplateDay {
    private boolean isValidated;
    @ManyToOne
    @JoinColumn(name = "validatedRoadMap_id")
    @JsonBackReference
    private ValidatedRoadMap validatedRoadMap;

    @OneToMany(mappedBy = "dailyRoadMap", cascade = CascadeType.ALL, orphanRemoval = true)
    @JsonManagedReference
    private List<ValidatedRoad> validatedRoadList;

    @OneToOne
    @JoinColumn(name = "totalRoadMapDaily_id")
    @JsonBackReference
    private TotalRoadMapDaily totalRoadMapDaily;
}
