package com.marketingconfort.adanev.vsn.roadMap.models.Validation;

import jakarta.persistence.*;
import lombok.Getter;
import lombok.Setter;

import java.time.Duration;

@Entity
@Getter
@Setter
@Inheritance(strategy = InheritanceType.TABLE_PER_CLASS)
public abstract class TotalRoadMap {
    @Id
    @GeneratedValue(strategy = GenerationType.SEQUENCE, generator = "total_road_seq")
    @SequenceGenerator(name = "total_road_seq", sequenceName = "total_road_seq", allocationSize = 1)
    private Long id;
    private Duration totalDay;
    private Double totalCentieme;
    private Duration deduction;
    private Double paidHoursCentieme ;
    private Duration delta;
    private Duration forfait;
    private Double nightHours;
    private Double waitingHours;
    private int numberVacations;

    public TotalRoadMap() {
        this.totalDay = Duration.ZERO;
        this.totalCentieme = 0.0;
        this.deduction = Duration.ZERO;
        this.paidHoursCentieme = 0.0;
        this.delta = Duration.ZERO;
        this.forfait = Duration.ZERO;
        this.nightHours = 0.0;
        this.waitingHours = 0.0;
        this.numberVacations = 0;
    }
}
