package com.marketingconfort.adanev.vsn.roadMap.models.Validation;

import com.fasterxml.jackson.annotation.JsonBackReference;
import com.fasterxml.jackson.annotation.JsonManagedReference;
import com.marketingconfort.adanev.vsn.roadMap.enums.Status;
import jakarta.persistence.*;
import lombok.*;

import java.time.LocalDateTime;
import java.util.List;

@Entity
@Getter
@Setter
@AllArgsConstructor
@NoArgsConstructor
public class ValidatedRoadMap   {
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Long id;
    private String name;
    private LocalDateTime date;
    @Enumerated(EnumType.STRING)
    private Status status;
    @OneToMany(mappedBy = "validatedRoadMap")
    @JsonManagedReference
    private List<DailyRoadMap>  dailyRoadMapList;

    @OneToOne
    @JoinColumn(name = "totalRoadMapMonthly_id")
    @JsonBackReference
    private TotalRoadMapMonthly totalRoadMapMonthly;

    @Column(name = "driver_id")
    private Long driverId;
    private String driverName;
}
