package com.marketingconfort.adanev.vsn.roadMap.models;

import com.fasterxml.jackson.annotation.JsonBackReference;
import com.fasterxml.jackson.annotation.JsonManagedReference;
import jakarta.persistence.*;
import lombok.*;

import java.util.List;

@Entity
@Getter
@Setter
@AllArgsConstructor
@NoArgsConstructor
public class WorkedDay extends TemplateDay {
    private double fuelAmount;
    private String observation;
    @ManyToOne
    @JoinColumn(name = "driverRoadMap_id")
    @JsonBackReference
    private DriverRoadMap driverRoadMap;

    @OneToOne(mappedBy = "workedDay")
    @JsonManagedReference
    private MileageIntervall mileageIntervall;

    @OneToMany(mappedBy = "workedDay")
    @JsonManagedReference
    private List<DriverRoad> driverRoadList;

    @OneToMany(mappedBy = "workedDay")
    @JsonManagedReference
    private List<OtherTrip> otherTripList;

}
