package com.marketingconfort.adanev.vsn.user.enums;

import java.util.*;

public enum Permission {
    /** Appel d'offre */
    APPEL_OFFRE("APPEL_OFFRE"),
    APPEL_OFFRE_DELETE("APPEL_OFFRE:DELETE"),
    APPEL_OFFRE_MODIFY("APPEL_OFFRE:MODIFY"),
    APPEL_OFFRE_READ("APPEL_OFFRE:READ"),
    APPEL_OFFRE_WRITE("APPEL_OFFRE:WRITE"),
    /** Configuration Admin */
    CONFIGURATION_ADMIN("CONFIGURATION_ADMIN"),
    /** Agent et Rôle */
    CONFIGURATION_ADMIN_AGENT_ET_ROLE("CONFIGURATION_ADMIN:AGENT_ET_ROLE"),
    CONFIGURATION_ADMIN_AGENT_ET_ROLE_DELETE("CONFIGURATION_ADMIN:AGENT_ET_ROLE:DELETE"),
    CONFIGURATION_ADMIN_AGENT_ET_ROLE_MODIFY("CONFIGURATION_ADMIN:AGENT_ET_ROLE:MODIFY"),
    CONFIGURATION_ADMIN_AGENT_ET_ROLE_READ("CONFIGURATION_ADMIN:AGENT_ET_ROLE:READ"),
    CONFIGURATION_ADMIN_AGENT_ET_ROLE_WRITE("CONFIGURATION_ADMIN:AGENT_ET_ROLE:WRITE"),
    /** Gestion Email */
    CONFIGURATION_ADMIN_GESTION_EMAIL("CONFIGURATION_ADMIN:GESTION_EMAIL"),
    CONFIGURATION_ADMIN_GESTION_EMAIL_DELETE("CONFIGURATION_ADMIN:GESTION_EMAIL:DELETE"),
    CONFIGURATION_ADMIN_GESTION_EMAIL_MODIFY("CONFIGURATION_ADMIN:GESTION_EMAIL:MODIFY"),
    CONFIGURATION_ADMIN_GESTION_EMAIL_READ("CONFIGURATION_ADMIN:GESTION_EMAIL:READ"),
    CONFIGURATION_ADMIN_GESTION_EMAIL_WRITE("CONFIGURATION_ADMIN:GESTION_EMAIL:WRITE"),
    /** Infrastructure */
    CONFIGURATION_ADMIN_INFRASTRUCTURE("CONFIGURATION_ADMIN:INFRASTRUCTURE"),
    CONFIGURATION_ADMIN_INFRASTRUCTURE_DELETE("CONFIGURATION_ADMIN:INFRASTRUCTURE:DELETE"),
    CONFIGURATION_ADMIN_INFRASTRUCTURE_MODIFY("CONFIGURATION_ADMIN:INFRASTRUCTURE:MODIFY"),
    CONFIGURATION_ADMIN_INFRASTRUCTURE_READ("CONFIGURATION_ADMIN:INFRASTRUCTURE:READ"),
    CONFIGURATION_ADMIN_INFRASTRUCTURE_WRITE("CONFIGURATION_ADMIN:INFRASTRUCTURE:WRITE"),
    /** Exploitation */
    EXPLOITATION("EXPLOITATION"),
    /** Chauffeur */
    EXPLOITATION_CHAUFFEUR("EXPLOITATION:CHAUFFEUR"),
    /** Absence */
    EXPLOITATION_CHAUFFEUR_ABSENCE_CHAUFFEUR("EXPLOITATION:CHAUFFEUR:ABSENCE_CHAUFFEUR"),
    EXPLOITATION_CHAUFFEUR_ABSENCE_CHAUFFEUR_DELETE("EXPLOITATION:CHAUFFEUR:ABSENCE_CHAUFFEUR:DELETE"),
    EXPLOITATION_CHAUFFEUR_ABSENCE_CHAUFFEUR_MODIFY("EXPLOITATION:CHAUFFEUR:ABSENCE_CHAUFFEUR:MODIFY"),
    EXPLOITATION_CHAUFFEUR_ABSENCE_CHAUFFEUR_READ("EXPLOITATION:CHAUFFEUR:ABSENCE_CHAUFFEUR:READ"),
    EXPLOITATION_CHAUFFEUR_ABSENCE_CHAUFFEUR_WRITE("EXPLOITATION:CHAUFFEUR:ABSENCE_CHAUFFEUR:WRITE"),
    /** Feuille de Route */
    EXPLOITATION_CHAUFFEUR_FEUILLE_DE_ROUTE("EXPLOITATION:CHAUFFEUR:FEUILLE_DE_ROUTE"),
    EXPLOITATION_CHAUFFEUR_FEUILLE_DE_ROUTE_DELETE("EXPLOITATION:CHAUFFEUR:FEUILLE_DE_ROUTE:DELETE"),
    EXPLOITATION_CHAUFFEUR_FEUILLE_DE_ROUTE_MODIFY("EXPLOITATION:CHAUFFEUR:FEUILLE_DE_ROUTE:MODIFY"),
    EXPLOITATION_CHAUFFEUR_FEUILLE_DE_ROUTE_READ("EXPLOITATION:CHAUFFEUR:FEUILLE_DE_ROUTE:READ"),
    EXPLOITATION_CHAUFFEUR_FEUILLE_DE_ROUTE_WRITE("EXPLOITATION:CHAUFFEUR:FEUILLE_DE_ROUTE:WRITE"),
    /** Liste Chauffeur */
    EXPLOITATION_CHAUFFEUR_LISTE_CHAUFFEUR("EXPLOITATION:CHAUFFEUR:LISTE_CHAUFFEUR"),
    EXPLOITATION_CHAUFFEUR_LISTE_CHAUFFEUR_DELETE("EXPLOITATION:CHAUFFEUR:LISTE_CHAUFFEUR:DELETE"),
    EXPLOITATION_CHAUFFEUR_LISTE_CHAUFFEUR_MODIFY("EXPLOITATION:CHAUFFEUR:LISTE_CHAUFFEUR:MODIFY"),
    EXPLOITATION_CHAUFFEUR_LISTE_CHAUFFEUR_READ("EXPLOITATION:CHAUFFEUR:LISTE_CHAUFFEUR:READ"),
    EXPLOITATION_CHAUFFEUR_LISTE_CHAUFFEUR_WRITE("EXPLOITATION:CHAUFFEUR:LISTE_CHAUFFEUR:WRITE"),
    /** Planning Chauffeur */
    EXPLOITATION_CHAUFFEUR_PLANNING_CHAUFFEUR("EXPLOITATION:CHAUFFEUR:PLANNING_CHAUFFEUR"),
    EXPLOITATION_CHAUFFEUR_PLANNING_CHAUFFEUR_DELETE("EXPLOITATION:CHAUFFEUR:PLANNING_CHAUFFEUR:DELETE"),
    EXPLOITATION_CHAUFFEUR_PLANNING_CHAUFFEUR_MODIFY("EXPLOITATION:CHAUFFEUR:PLANNING_CHAUFFEUR:MODIFY"),
    EXPLOITATION_CHAUFFEUR_PLANNING_CHAUFFEUR_READ("EXPLOITATION:CHAUFFEUR:PLANNING_CHAUFFEUR:READ"),
    EXPLOITATION_CHAUFFEUR_PLANNING_CHAUFFEUR_WRITE("EXPLOITATION:CHAUFFEUR:PLANNING_CHAUFFEUR:WRITE"),
    /** Suivi Trajet */
    EXPLOITATION_CHAUFFEUR_SUIVI_TRAJET("EXPLOITATION:CHAUFFEUR:SUIVI_TRAJET"),
    EXPLOITATION_CHAUFFEUR_SUIVI_TRAJET_DELETE("EXPLOITATION:CHAUFFEUR:SUIVI_TRAJET:DELETE"),
    EXPLOITATION_CHAUFFEUR_SUIVI_TRAJET_MODIFY("EXPLOITATION:CHAUFFEUR:SUIVI_TRAJET:MODIFY"),
    EXPLOITATION_CHAUFFEUR_SUIVI_TRAJET_READ("EXPLOITATION:CHAUFFEUR:SUIVI_TRAJET:READ"),
    EXPLOITATION_CHAUFFEUR_SUIVI_TRAJET_WRITE("EXPLOITATION:CHAUFFEUR:SUIVI_TRAJET:WRITE"),
    /** Circuit / Usager */
    EXPLOITATION_CIRCUIT_USAGER("EXPLOITATION:CIRCUIT_USAGER"),
    /** Absence */
    EXPLOITATION_CIRCUIT_USAGER_ABSENCE("EXPLOITATION:CIRCUIT_USAGER:ABSENCE"),
    EXPLOITATION_CIRCUIT_USAGER_ABSENCE_DELETE("EXPLOITATION:CIRCUIT_USAGER:ABSENCE:DELETE"),
    EXPLOITATION_CIRCUIT_USAGER_ABSENCE_MODIFY("EXPLOITATION:CIRCUIT_USAGER:ABSENCE:MODIFY"),
    EXPLOITATION_CIRCUIT_USAGER_ABSENCE_READ("EXPLOITATION:CIRCUIT_USAGER:ABSENCE:READ"),
    EXPLOITATION_CIRCUIT_USAGER_ABSENCE_WRITE("EXPLOITATION:CIRCUIT_USAGER:ABSENCE:WRITE"),
    /** Avenant */
    EXPLOITATION_CIRCUIT_USAGER_AVENANT("EXPLOITATION:CIRCUIT_USAGER:AVENANT"),
    EXPLOITATION_CIRCUIT_USAGER_AVENANT_DELETE("EXPLOITATION:CIRCUIT_USAGER:AVENANT:DELETE"),
    EXPLOITATION_CIRCUIT_USAGER_AVENANT_MODIFY("EXPLOITATION:CIRCUIT_USAGER:AVENANT:MODIFY"),
    EXPLOITATION_CIRCUIT_USAGER_AVENANT_READ("EXPLOITATION:CIRCUIT_USAGER:AVENANT:READ"),
    EXPLOITATION_CIRCUIT_USAGER_AVENANT_WRITE("EXPLOITATION:CIRCUIT_USAGER:AVENANT:WRITE"),
    /** Circuit */
    EXPLOITATION_CIRCUIT_USAGER_CIRCUIT("EXPLOITATION:CIRCUIT_USAGER:CIRCUIT"),
    EXPLOITATION_CIRCUIT_USAGER_CIRCUIT_DELETE("EXPLOITATION:CIRCUIT_USAGER:CIRCUIT:DELETE"),
    EXPLOITATION_CIRCUIT_USAGER_CIRCUIT_MODIFY("EXPLOITATION:CIRCUIT_USAGER:CIRCUIT:MODIFY"),
    EXPLOITATION_CIRCUIT_USAGER_CIRCUIT_READ("EXPLOITATION:CIRCUIT_USAGER:CIRCUIT:READ"),
    EXPLOITATION_CIRCUIT_USAGER_CIRCUIT_WRITE("EXPLOITATION:CIRCUIT_USAGER:CIRCUIT:WRITE"),
    /** Trajet */
    EXPLOITATION_CIRCUIT_USAGER_TRAJET("EXPLOITATION:CIRCUIT_USAGER:TRAJET"),
    EXPLOITATION_CIRCUIT_USAGER_TRAJET_DELETE("EXPLOITATION:CIRCUIT_USAGER:TRAJET:DELETE"),
    EXPLOITATION_CIRCUIT_USAGER_TRAJET_MODIFY("EXPLOITATION:CIRCUIT_USAGER:TRAJET:MODIFY"),
    EXPLOITATION_CIRCUIT_USAGER_TRAJET_READ("EXPLOITATION:CIRCUIT_USAGER:TRAJET:READ"),
    EXPLOITATION_CIRCUIT_USAGER_TRAJET_WRITE("EXPLOITATION:CIRCUIT_USAGER:TRAJET:WRITE"),
    /** Usager */
    EXPLOITATION_CIRCUIT_USAGER_USAGER("EXPLOITATION:CIRCUIT_USAGER:USAGER"),
    EXPLOITATION_CIRCUIT_USAGER_USAGER_DELETE("EXPLOITATION:CIRCUIT_USAGER:USAGER:DELETE"),
    EXPLOITATION_CIRCUIT_USAGER_USAGER_MODIFY("EXPLOITATION:CIRCUIT_USAGER:USAGER:MODIFY"),
    EXPLOITATION_CIRCUIT_USAGER_USAGER_READ("EXPLOITATION:CIRCUIT_USAGER:USAGER:READ"),
    EXPLOITATION_CIRCUIT_USAGER_USAGER_WRITE("EXPLOITATION:CIRCUIT_USAGER:USAGER:WRITE"),
    /** Client */
    EXPLOITATION_CLIENT("EXPLOITATION:CLIENT"),
    EXPLOITATION_CLIENT_DELETE("EXPLOITATION:CLIENT:DELETE"),
    EXPLOITATION_CLIENT_MODIFY("EXPLOITATION:CLIENT:MODIFY"),
    EXPLOITATION_CLIENT_READ("EXPLOITATION:CLIENT:READ"),
    EXPLOITATION_CLIENT_WRITE("EXPLOITATION:CLIENT:WRITE"),
    /** Contrat */
    EXPLOITATION_CONTRAT("EXPLOITATION:CONTRAT"),
    EXPLOITATION_CONTRAT_DELETE("EXPLOITATION:CONTRAT:DELETE"),
    EXPLOITATION_CONTRAT_MODIFY("EXPLOITATION:CONTRAT:MODIFY"),
    EXPLOITATION_CONTRAT_READ("EXPLOITATION:CONTRAT:READ"),
    EXPLOITATION_CONTRAT_WRITE("EXPLOITATION:CONTRAT:WRITE"),
    /** Etablissement */
    EXPLOITATION_ETABLISSEMENT("EXPLOITATION:ETABLISSEMENT"),
    /** Feuille de Présence */
    EXPLOITATION_ETABLISSEMENT_FEUILLE_DE_PRESENCE("EXPLOITATION:ETABLISSEMENT:FEUILLE_DE_PRESENCE"),
    EXPLOITATION_ETABLISSEMENT_FEUILLE_DE_PRESENCE_DELETE("EXPLOITATION:ETABLISSEMENT:FEUILLE_DE_PRESENCE:DELETE"),
    EXPLOITATION_ETABLISSEMENT_FEUILLE_DE_PRESENCE_MODIFY("EXPLOITATION:ETABLISSEMENT:FEUILLE_DE_PRESENCE:MODIFY"),
    EXPLOITATION_ETABLISSEMENT_FEUILLE_DE_PRESENCE_READ("EXPLOITATION:ETABLISSEMENT:FEUILLE_DE_PRESENCE:READ"),
    EXPLOITATION_ETABLISSEMENT_FEUILLE_DE_PRESENCE_WRITE("EXPLOITATION:ETABLISSEMENT:FEUILLE_DE_PRESENCE:WRITE"),
    /** Liste Établissement */
    EXPLOITATION_ETABLISSEMENT_LISTE_ETABLISSEMENT("EXPLOITATION:ETABLISSEMENT:LISTE_ETABLISSEMENT"),
    EXPLOITATION_ETABLISSEMENT_LISTE_ETABLISSEMENT_DELETE("EXPLOITATION:ETABLISSEMENT:LISTE_ETABLISSEMENT:DELETE"),
    EXPLOITATION_ETABLISSEMENT_LISTE_ETABLISSEMENT_MODIFY("EXPLOITATION:ETABLISSEMENT:LISTE_ETABLISSEMENT:MODIFY"),
    EXPLOITATION_ETABLISSEMENT_LISTE_ETABLISSEMENT_READ("EXPLOITATION:ETABLISSEMENT:LISTE_ETABLISSEMENT:READ"),
    EXPLOITATION_ETABLISSEMENT_LISTE_ETABLISSEMENT_WRITE("EXPLOITATION:ETABLISSEMENT:LISTE_ETABLISSEMENT:WRITE"),
    /** Vacance / Jour Férié */
    EXPLOITATION_ETABLISSEMENT_VACANCE_JOUR_FERIE("EXPLOITATION:ETABLISSEMENT:VACANCE_JOUR_FERIE"),
    EXPLOITATION_ETABLISSEMENT_VACANCE_JOUR_FERIE_DELETE("EXPLOITATION:ETABLISSEMENT:VACANCE_JOUR_FERIE:DELETE"),
    EXPLOITATION_ETABLISSEMENT_VACANCE_JOUR_FERIE_MODIFY("EXPLOITATION:ETABLISSEMENT:VACANCE_JOUR_FERIE:MODIFY"),
    EXPLOITATION_ETABLISSEMENT_VACANCE_JOUR_FERIE_READ("EXPLOITATION:ETABLISSEMENT:VACANCE_JOUR_FERIE:READ"),
    EXPLOITATION_ETABLISSEMENT_VACANCE_JOUR_FERIE_WRITE("EXPLOITATION:ETABLISSEMENT:VACANCE_JOUR_FERIE:WRITE"),
    /** Préparation */
    EXPLOITATION_PREPARATION("EXPLOITATION:PREPARATION"),
    /** Préparation Chauffeur */
    EXPLOITATION_PREPARATION_PREPARATION_CHAUFFEUR("EXPLOITATION:PREPARATION:PREPARATION_CHAUFFEUR"),
    EXPLOITATION_PREPARATION_PREPARATION_CHAUFFEUR_DELETE("EXPLOITATION:PREPARATION:PREPARATION_CHAUFFEUR:DELETE"),
    EXPLOITATION_PREPARATION_PREPARATION_CHAUFFEUR_MODIFY("EXPLOITATION:PREPARATION:PREPARATION_CHAUFFEUR:MODIFY"),
    EXPLOITATION_PREPARATION_PREPARATION_CHAUFFEUR_READ("EXPLOITATION:PREPARATION:PREPARATION_CHAUFFEUR:READ"),
    EXPLOITATION_PREPARATION_PREPARATION_CHAUFFEUR_WRITE("EXPLOITATION:PREPARATION:PREPARATION_CHAUFFEUR:WRITE"),
    /** Préparation Circuit */
    EXPLOITATION_PREPARATION_PREPARATION_CIRCUIT("EXPLOITATION:PREPARATION:PREPARATION_CIRCUIT"),
    EXPLOITATION_PREPARATION_PREPARATION_CIRCUIT_DELETE("EXPLOITATION:PREPARATION:PREPARATION_CIRCUIT:DELETE"),
    EXPLOITATION_PREPARATION_PREPARATION_CIRCUIT_MODIFY("EXPLOITATION:PREPARATION:PREPARATION_CIRCUIT:MODIFY"),
    EXPLOITATION_PREPARATION_PREPARATION_CIRCUIT_READ("EXPLOITATION:PREPARATION:PREPARATION_CIRCUIT:READ"),
    EXPLOITATION_PREPARATION_PREPARATION_CIRCUIT_WRITE("EXPLOITATION:PREPARATION:PREPARATION_CIRCUIT:WRITE"),
    /** Préparation Usager */
    EXPLOITATION_PREPARATION_PREPARATION_USAGER("EXPLOITATION:PREPARATION:PREPARATION_USAGER"),
    EXPLOITATION_PREPARATION_PREPARATION_USAGER_DELETE("EXPLOITATION:PREPARATION:PREPARATION_USAGER:DELETE"),
    EXPLOITATION_PREPARATION_PREPARATION_USAGER_MODIFY("EXPLOITATION:PREPARATION:PREPARATION_USAGER:MODIFY"),
    EXPLOITATION_PREPARATION_PREPARATION_USAGER_READ("EXPLOITATION:PREPARATION:PREPARATION_USAGER:READ"),
    EXPLOITATION_PREPARATION_PREPARATION_USAGER_WRITE("EXPLOITATION:PREPARATION:PREPARATION_USAGER:WRITE"),
    /** Facturation et Paiement */
    FACTURATION_PAIEMENT("FACTURATION_PAIEMENT"),
    FACTURATION_PAIEMENT_DELETE("FACTURATION_PAIEMENT:DELETE"),
    FACTURATION_PAIEMENT_MODIFY("FACTURATION_PAIEMENT:MODIFY"),
    FACTURATION_PAIEMENT_READ("FACTURATION_PAIEMENT:READ"),
    FACTURATION_PAIEMENT_WRITE("FACTURATION_PAIEMENT:WRITE"),
    /** Flottes */
    FLOTTES("FLOTTES"),
    /** Carburant et Consommation */
    FLOTTES_CARBURANT_CONSOMMATION("FLOTTES:CARBURANT_CONSOMMATION"),
    /** Anomalie traitée */
    FLOTTES_CARBURANT_CONSOMMATION_ANOMALIE_TRAITEE("FLOTTES:CARBURANT_CONSOMMATION:ANOMALIE_TRAITEE"),
    FLOTTES_CARBURANT_CONSOMMATION_ANOMALIE_TRAITEE_DELETE("FLOTTES:CARBURANT_CONSOMMATION:ANOMALIE_TRAITEE:DELETE"),
    FLOTTES_CARBURANT_CONSOMMATION_ANOMALIE_TRAITEE_MODIFY("FLOTTES:CARBURANT_CONSOMMATION:ANOMALIE_TRAITEE:MODIFY"),
    FLOTTES_CARBURANT_CONSOMMATION_ANOMALIE_TRAITEE_READ("FLOTTES:CARBURANT_CONSOMMATION:ANOMALIE_TRAITEE:READ"),
    FLOTTES_CARBURANT_CONSOMMATION_ANOMALIE_TRAITEE_WRITE("FLOTTES:CARBURANT_CONSOMMATION:ANOMALIE_TRAITEE:WRITE"),
    /** Suivi Carburant */
    FLOTTES_CARBURANT_CONSOMMATION_SUIVI_CARBURANT("FLOTTES:CARBURANT_CONSOMMATION:SUIVI_CARBURANT"),
    FLOTTES_CARBURANT_CONSOMMATION_SUIVI_CARBURANT_DELETE("FLOTTES:CARBURANT_CONSOMMATION:SUIVI_CARBURANT:DELETE"),
    FLOTTES_CARBURANT_CONSOMMATION_SUIVI_CARBURANT_MODIFY("FLOTTES:CARBURANT_CONSOMMATION:SUIVI_CARBURANT:MODIFY"),
    FLOTTES_CARBURANT_CONSOMMATION_SUIVI_CARBURANT_READ("FLOTTES:CARBURANT_CONSOMMATION:SUIVI_CARBURANT:READ"),
    FLOTTES_CARBURANT_CONSOMMATION_SUIVI_CARBURANT_WRITE("FLOTTES:CARBURANT_CONSOMMATION:SUIVI_CARBURANT:WRITE"),
    /** Suivi Kilométrage */
    FLOTTES_CARBURANT_CONSOMMATION_SUIVI_KILOMETRAGE("FLOTTES:CARBURANT_CONSOMMATION:SUIVI_KILOMETRAGE"),
    FLOTTES_CARBURANT_CONSOMMATION_SUIVI_KILOMETRAGE_DELETE("FLOTTES:CARBURANT_CONSOMMATION:SUIVI_KILOMETRAGE:DELETE"),
    FLOTTES_CARBURANT_CONSOMMATION_SUIVI_KILOMETRAGE_MODIFY("FLOTTES:CARBURANT_CONSOMMATION:SUIVI_KILOMETRAGE:MODIFY"),
    FLOTTES_CARBURANT_CONSOMMATION_SUIVI_KILOMETRAGE_READ("FLOTTES:CARBURANT_CONSOMMATION:SUIVI_KILOMETRAGE:READ"),
    FLOTTES_CARBURANT_CONSOMMATION_SUIVI_KILOMETRAGE_WRITE("FLOTTES:CARBURANT_CONSOMMATION:SUIVI_KILOMETRAGE:WRITE"),
    /** Entretien */
    FLOTTES_ENTRETIEN("FLOTTES:ENTRETIEN"),
    FLOTTES_ENTRETIEN_DELETE("FLOTTES:ENTRETIEN:DELETE"),
    FLOTTES_ENTRETIEN_MODIFY("FLOTTES:ENTRETIEN:MODIFY"),
    FLOTTES_ENTRETIEN_READ("FLOTTES:ENTRETIEN:READ"),
    FLOTTES_ENTRETIEN_WRITE("FLOTTES:ENTRETIEN:WRITE"),
    /** Incidents */
    FLOTTES_INCIDENTS("FLOTTES:INCIDENTS"),
    FLOTTES_INCIDENTS_DELETE("FLOTTES:INCIDENTS:DELETE"),
    FLOTTES_INCIDENTS_MODIFY("FLOTTES:INCIDENTS:MODIFY"),
    FLOTTES_INCIDENTS_READ("FLOTTES:INCIDENTS:READ"),
    FLOTTES_INCIDENTS_WRITE("FLOTTES:INCIDENTS:WRITE"),
    /** Véhicule */
    FLOTTES_VEHICULE("FLOTTES:VEHICULE"),
    FLOTTES_VEHICULE_DELETE("FLOTTES:VEHICULE:DELETE"),
    FLOTTES_VEHICULE_MODIFY("FLOTTES:VEHICULE:MODIFY"),
    FLOTTES_VEHICULE_READ("FLOTTES:VEHICULE:READ"),
    FLOTTES_VEHICULE_WRITE("FLOTTES:VEHICULE:WRITE"),
    /** Géolocalisation */
    GEOLOCALISATION("GEOLOCALISATION"),
    GEOLOCALISATION_DELETE("GEOLOCALISATION:DELETE"),
    GEOLOCALISATION_MODIFY("GEOLOCALISATION:MODIFY"),
    GEOLOCALISATION_READ("GEOLOCALISATION:READ"),
    GEOLOCALISATION_WRITE("GEOLOCALISATION:WRITE"),
    /** Planning */
    PLANNING("PLANNING"),
    /** Planning Chauffeur */
    PLANNING_PLANNING_CHAUFFEUR("PLANNING:PLANNING_CHAUFFEUR"),
    PLANNING_PLANNING_CHAUFFEUR_DELETE("PLANNING:PLANNING_CHAUFFEUR:DELETE"),
    PLANNING_PLANNING_CHAUFFEUR_MODIFY("PLANNING:PLANNING_CHAUFFEUR:MODIFY"),
    PLANNING_PLANNING_CHAUFFEUR_READ("PLANNING:PLANNING_CHAUFFEUR:READ"),
    PLANNING_PLANNING_CHAUFFEUR_WRITE("PLANNING:PLANNING_CHAUFFEUR:WRITE"),
    /** Planning de Location */
    PLANNING_PLANNING_LOCATION("PLANNING:PLANNING_LOCATION"),
    PLANNING_PLANNING_LOCATION_DELETE("PLANNING:PLANNING_LOCATION:DELETE"),
    PLANNING_PLANNING_LOCATION_MODIFY("PLANNING:PLANNING_LOCATION:MODIFY"),
    PLANNING_PLANNING_LOCATION_READ("PLANNING:PLANNING_LOCATION:READ"),
    PLANNING_PLANNING_LOCATION_WRITE("PLANNING:PLANNING_LOCATION:WRITE"),
    /** Planning Véhicule */
    PLANNING_PLANNING_VEHICULE("PLANNING:PLANNING_VEHICULE"),
    PLANNING_PLANNING_VEHICULE_DELETE("PLANNING:PLANNING_VEHICULE:DELETE"),
    PLANNING_PLANNING_VEHICULE_MODIFY("PLANNING:PLANNING_VEHICULE:MODIFY"),
    PLANNING_PLANNING_VEHICULE_READ("PLANNING:PLANNING_VEHICULE:READ"),
    PLANNING_PLANNING_VEHICULE_WRITE("PLANNING:PLANNING_VEHICULE:WRITE"),
    /** RH */
    RH("RH"),
    /** Document */
    RH_DOCUMENT("RH:DOCUMENT"),
    RH_DOCUMENT_DELETE("RH:DOCUMENT:DELETE"),
    RH_DOCUMENT_MODIFY("RH:DOCUMENT:MODIFY"),
    RH_DOCUMENT_READ("RH:DOCUMENT:READ"),
    RH_DOCUMENT_WRITE("RH:DOCUMENT:WRITE"),
    /** Gestion Absence */
    RH_GESTION_ABSENCE("RH:GESTION_ABSENCE"),
    RH_GESTION_ABSENCE_DELETE("RH:GESTION_ABSENCE:DELETE"),
    RH_GESTION_ABSENCE_MODIFY("RH:GESTION_ABSENCE:MODIFY"),
    RH_GESTION_ABSENCE_READ("RH:GESTION_ABSENCE:READ"),
    RH_GESTION_ABSENCE_WRITE("RH:GESTION_ABSENCE:WRITE"),
    /** Gestion de Calendrier */
    RH_GESTION_DE_CALENDRIER("RH:GESTION_DE_CALENDRIER"),
    RH_GESTION_DE_CALENDRIER_DELETE("RH:GESTION_DE_CALENDRIER:DELETE"),
    RH_GESTION_DE_CALENDRIER_MODIFY("RH:GESTION_DE_CALENDRIER:MODIFY"),
    RH_GESTION_DE_CALENDRIER_READ("RH:GESTION_DE_CALENDRIER:READ"),
    RH_GESTION_DE_CALENDRIER_WRITE("RH:GESTION_DE_CALENDRIER:WRITE"),
    /** Gestion de Congé */
    RH_GESTION_DE_CONGE("RH:GESTION_DE_CONGE"),
    RH_GESTION_DE_CONGE_DELETE("RH:GESTION_DE_CONGE:DELETE"),
    RH_GESTION_DE_CONGE_MODIFY("RH:GESTION_DE_CONGE:MODIFY"),
    RH_GESTION_DE_CONGE_READ("RH:GESTION_DE_CONGE:READ"),
    RH_GESTION_DE_CONGE_WRITE("RH:GESTION_DE_CONGE:WRITE"),
    /** Gestion de Salariés */
    RH_GESTION_DE_SALARIES("RH:GESTION_DE_SALARIES"),
    RH_GESTION_DE_SALARIES_DELETE("RH:GESTION_DE_SALARIES:DELETE"),
    RH_GESTION_DE_SALARIES_MODIFY("RH:GESTION_DE_SALARIES:MODIFY"),
    RH_GESTION_DE_SALARIES_READ("RH:GESTION_DE_SALARIES:READ"),
    RH_GESTION_DE_SALARIES_WRITE("RH:GESTION_DE_SALARIES:WRITE"),
    /** Gestion recrutement */
    RH_GESTION_RECRUTEMENT("RH:GESTION_RECRUTEMENT"),
    /** Besoins Recrutement */
    RH_GESTION_RECRUTEMENT_BESOINS_RECRUTEMENT("RH:GESTION_RECRUTEMENT:BESOINS_RECRUTEMENT"),
    RH_GESTION_RECRUTEMENT_BESOINS_RECRUTEMENT_DELETE("RH:GESTION_RECRUTEMENT:BESOINS_RECRUTEMENT:DELETE"),
    RH_GESTION_RECRUTEMENT_BESOINS_RECRUTEMENT_MODIFY("RH:GESTION_RECRUTEMENT:BESOINS_RECRUTEMENT:MODIFY"),
    RH_GESTION_RECRUTEMENT_BESOINS_RECRUTEMENT_READ("RH:GESTION_RECRUTEMENT:BESOINS_RECRUTEMENT:READ"),
    RH_GESTION_RECRUTEMENT_BESOINS_RECRUTEMENT_WRITE("RH:GESTION_RECRUTEMENT:BESOINS_RECRUTEMENT:WRITE"),
    /** Candidature chauffeur */
    RH_GESTION_RECRUTEMENT_CANDIDATURE_CHAUFFEUR("RH:GESTION_RECRUTEMENT:CANDIDATURE_CHAUFFEUR"),
    RH_GESTION_RECRUTEMENT_CANDIDATURE_CHAUFFEUR_DELETE("RH:GESTION_RECRUTEMENT:CANDIDATURE_CHAUFFEUR:DELETE"),
    RH_GESTION_RECRUTEMENT_CANDIDATURE_CHAUFFEUR_MODIFY("RH:GESTION_RECRUTEMENT:CANDIDATURE_CHAUFFEUR:MODIFY"),
    RH_GESTION_RECRUTEMENT_CANDIDATURE_CHAUFFEUR_READ("RH:GESTION_RECRUTEMENT:CANDIDATURE_CHAUFFEUR:READ"),
    RH_GESTION_RECRUTEMENT_CANDIDATURE_CHAUFFEUR_WRITE("RH:GESTION_RECRUTEMENT:CANDIDATURE_CHAUFFEUR:WRITE"),
    /** Candidature sédentaire */
    RH_GESTION_RECRUTEMENT_CANDIDATURE_SEDENTAIRE("RH:GESTION_RECRUTEMENT:CANDIDATURE_SEDENTAIRE"),
    RH_GESTION_RECRUTEMENT_CANDIDATURE_SEDENTAIRE_DELETE("RH:GESTION_RECRUTEMENT:CANDIDATURE_SEDENTAIRE:DELETE"),
    RH_GESTION_RECRUTEMENT_CANDIDATURE_SEDENTAIRE_MODIFY("RH:GESTION_RECRUTEMENT:CANDIDATURE_SEDENTAIRE:MODIFY"),
    RH_GESTION_RECRUTEMENT_CANDIDATURE_SEDENTAIRE_READ("RH:GESTION_RECRUTEMENT:CANDIDATURE_SEDENTAIRE:READ"),
    RH_GESTION_RECRUTEMENT_CANDIDATURE_SEDENTAIRE_WRITE("RH:GESTION_RECRUTEMENT:CANDIDATURE_SEDENTAIRE:WRITE"),
    /** RDV annuel */
    RH_RDV_ANNUEL("RH:RDV_ANNUEL"),
    RH_RDV_ANNUEL_DELETE("RH:RDV_ANNUEL:DELETE"),
    RH_RDV_ANNUEL_MODIFY("RH:RDV_ANNUEL:MODIFY"),
    RH_RDV_ANNUEL_READ("RH:RDV_ANNUEL:READ"),
    RH_RDV_ANNUEL_WRITE("RH:RDV_ANNUEL:WRITE"),
    /** Staff */
    STAFF("STAFF"),
    /** Gestion des documents */
    STAFF_GESTION_DOCUMENTS("STAFF:GESTION_DOCUMENTS"),
    STAFF_GESTION_DOCUMENTS_DELETE("STAFF:GESTION_DOCUMENTS:DELETE"),
    STAFF_GESTION_DOCUMENTS_MODIFY("STAFF:GESTION_DOCUMENTS:MODIFY"),
    STAFF_GESTION_DOCUMENTS_READ("STAFF:GESTION_DOCUMENTS:READ"),
    STAFF_GESTION_DOCUMENTS_WRITE("STAFF:GESTION_DOCUMENTS:WRITE");


    private final String path;
    Permission(String path) { this.path = path; }

    public String path() { return path; }

    private static final Map<Permission, List<Permission>> hierarchy = new HashMap<>();
    private static final Map<Permission, List<Permission>> implications = new HashMap<>();

    static {
        for (Permission p: values()) { hierarchy.put(p, new ArrayList<>()); implications.put(p, new ArrayList<>()); }
        hierarchy.get(EXPLOITATION_CIRCUIT_USAGER).add(EXPLOITATION_CIRCUIT_USAGER_USAGER);
        hierarchy.get(EXPLOITATION_CIRCUIT_USAGER).add(EXPLOITATION_CIRCUIT_USAGER_CIRCUIT);
        hierarchy.get(EXPLOITATION_CIRCUIT_USAGER).add(EXPLOITATION_CIRCUIT_USAGER_TRAJET);
        hierarchy.get(EXPLOITATION_CIRCUIT_USAGER).add(EXPLOITATION_CIRCUIT_USAGER_AVENANT);
        hierarchy.get(EXPLOITATION_CIRCUIT_USAGER).add(EXPLOITATION_CIRCUIT_USAGER_ABSENCE);
        hierarchy.get(EXPLOITATION_CONTRAT).add(EXPLOITATION_CONTRAT_READ);
        hierarchy.get(EXPLOITATION_CONTRAT).add(EXPLOITATION_CONTRAT_WRITE);
        hierarchy.get(EXPLOITATION_CONTRAT).add(EXPLOITATION_CONTRAT_MODIFY);
        hierarchy.get(EXPLOITATION_CONTRAT).add(EXPLOITATION_CONTRAT_DELETE);
        hierarchy.get(EXPLOITATION_CLIENT).add(EXPLOITATION_CLIENT_READ);
        hierarchy.get(EXPLOITATION_CLIENT).add(EXPLOITATION_CLIENT_WRITE);
        hierarchy.get(EXPLOITATION_CLIENT).add(EXPLOITATION_CLIENT_MODIFY);
        hierarchy.get(EXPLOITATION_CLIENT).add(EXPLOITATION_CLIENT_DELETE);
        hierarchy.get(EXPLOITATION_ETABLISSEMENT).add(EXPLOITATION_ETABLISSEMENT_LISTE_ETABLISSEMENT);
        hierarchy.get(EXPLOITATION_ETABLISSEMENT).add(EXPLOITATION_ETABLISSEMENT_VACANCE_JOUR_FERIE);
        hierarchy.get(EXPLOITATION_ETABLISSEMENT).add(EXPLOITATION_ETABLISSEMENT_FEUILLE_DE_PRESENCE);
        hierarchy.get(EXPLOITATION_CHAUFFEUR).add(EXPLOITATION_CHAUFFEUR_LISTE_CHAUFFEUR);
        hierarchy.get(EXPLOITATION_CHAUFFEUR).add(EXPLOITATION_CHAUFFEUR_PLANNING_CHAUFFEUR);
        hierarchy.get(EXPLOITATION_CHAUFFEUR).add(EXPLOITATION_CHAUFFEUR_FEUILLE_DE_ROUTE);
        hierarchy.get(EXPLOITATION_CHAUFFEUR).add(EXPLOITATION_CHAUFFEUR_SUIVI_TRAJET);
        hierarchy.get(EXPLOITATION_CHAUFFEUR).add(EXPLOITATION_CHAUFFEUR_ABSENCE_CHAUFFEUR);
        hierarchy.get(EXPLOITATION_PREPARATION).add(EXPLOITATION_PREPARATION_PREPARATION_USAGER);
        hierarchy.get(EXPLOITATION_PREPARATION).add(EXPLOITATION_PREPARATION_PREPARATION_CIRCUIT);
        hierarchy.get(EXPLOITATION_PREPARATION).add(EXPLOITATION_PREPARATION_PREPARATION_CHAUFFEUR);
        hierarchy.get(CONFIGURATION_ADMIN_INFRASTRUCTURE).add(CONFIGURATION_ADMIN_INFRASTRUCTURE_READ);
        hierarchy.get(CONFIGURATION_ADMIN_INFRASTRUCTURE).add(CONFIGURATION_ADMIN_INFRASTRUCTURE_WRITE);
        hierarchy.get(CONFIGURATION_ADMIN_INFRASTRUCTURE).add(CONFIGURATION_ADMIN_INFRASTRUCTURE_MODIFY);
        hierarchy.get(CONFIGURATION_ADMIN_INFRASTRUCTURE).add(CONFIGURATION_ADMIN_INFRASTRUCTURE_DELETE);
        hierarchy.get(CONFIGURATION_ADMIN_AGENT_ET_ROLE).add(CONFIGURATION_ADMIN_AGENT_ET_ROLE_READ);
        hierarchy.get(CONFIGURATION_ADMIN_AGENT_ET_ROLE).add(CONFIGURATION_ADMIN_AGENT_ET_ROLE_WRITE);
        hierarchy.get(CONFIGURATION_ADMIN_AGENT_ET_ROLE).add(CONFIGURATION_ADMIN_AGENT_ET_ROLE_MODIFY);
        hierarchy.get(CONFIGURATION_ADMIN_AGENT_ET_ROLE).add(CONFIGURATION_ADMIN_AGENT_ET_ROLE_DELETE);
        hierarchy.get(CONFIGURATION_ADMIN_GESTION_EMAIL).add(CONFIGURATION_ADMIN_GESTION_EMAIL_READ);
        hierarchy.get(CONFIGURATION_ADMIN_GESTION_EMAIL).add(CONFIGURATION_ADMIN_GESTION_EMAIL_WRITE);
        hierarchy.get(CONFIGURATION_ADMIN_GESTION_EMAIL).add(CONFIGURATION_ADMIN_GESTION_EMAIL_MODIFY);
        hierarchy.get(CONFIGURATION_ADMIN_GESTION_EMAIL).add(CONFIGURATION_ADMIN_GESTION_EMAIL_DELETE);
        hierarchy.get(FLOTTES_VEHICULE).add(FLOTTES_VEHICULE_READ);
        hierarchy.get(FLOTTES_VEHICULE).add(FLOTTES_VEHICULE_WRITE);
        hierarchy.get(FLOTTES_VEHICULE).add(FLOTTES_VEHICULE_MODIFY);
        hierarchy.get(FLOTTES_VEHICULE).add(FLOTTES_VEHICULE_DELETE);
        hierarchy.get(FLOTTES_ENTRETIEN).add(FLOTTES_ENTRETIEN_READ);
        hierarchy.get(FLOTTES_ENTRETIEN).add(FLOTTES_ENTRETIEN_WRITE);
        hierarchy.get(FLOTTES_ENTRETIEN).add(FLOTTES_ENTRETIEN_MODIFY);
        hierarchy.get(FLOTTES_ENTRETIEN).add(FLOTTES_ENTRETIEN_DELETE);
        hierarchy.get(FLOTTES_INCIDENTS).add(FLOTTES_INCIDENTS_READ);
        hierarchy.get(FLOTTES_INCIDENTS).add(FLOTTES_INCIDENTS_WRITE);
        hierarchy.get(FLOTTES_INCIDENTS).add(FLOTTES_INCIDENTS_MODIFY);
        hierarchy.get(FLOTTES_INCIDENTS).add(FLOTTES_INCIDENTS_DELETE);
        hierarchy.get(FLOTTES_CARBURANT_CONSOMMATION).add(FLOTTES_CARBURANT_CONSOMMATION_SUIVI_CARBURANT);
        hierarchy.get(FLOTTES_CARBURANT_CONSOMMATION).add(FLOTTES_CARBURANT_CONSOMMATION_SUIVI_KILOMETRAGE);
        hierarchy.get(FLOTTES_CARBURANT_CONSOMMATION).add(FLOTTES_CARBURANT_CONSOMMATION_ANOMALIE_TRAITEE);
        hierarchy.get(PLANNING_PLANNING_VEHICULE).add(PLANNING_PLANNING_VEHICULE_READ);
        hierarchy.get(PLANNING_PLANNING_VEHICULE).add(PLANNING_PLANNING_VEHICULE_WRITE);
        hierarchy.get(PLANNING_PLANNING_VEHICULE).add(PLANNING_PLANNING_VEHICULE_MODIFY);
        hierarchy.get(PLANNING_PLANNING_VEHICULE).add(PLANNING_PLANNING_VEHICULE_DELETE);
        hierarchy.get(PLANNING_PLANNING_CHAUFFEUR).add(PLANNING_PLANNING_CHAUFFEUR_READ);
        hierarchy.get(PLANNING_PLANNING_CHAUFFEUR).add(PLANNING_PLANNING_CHAUFFEUR_WRITE);
        hierarchy.get(PLANNING_PLANNING_CHAUFFEUR).add(PLANNING_PLANNING_CHAUFFEUR_MODIFY);
        hierarchy.get(PLANNING_PLANNING_CHAUFFEUR).add(PLANNING_PLANNING_CHAUFFEUR_DELETE);
        hierarchy.get(PLANNING_PLANNING_LOCATION).add(PLANNING_PLANNING_LOCATION_READ);
        hierarchy.get(PLANNING_PLANNING_LOCATION).add(PLANNING_PLANNING_LOCATION_WRITE);
        hierarchy.get(PLANNING_PLANNING_LOCATION).add(PLANNING_PLANNING_LOCATION_MODIFY);
        hierarchy.get(PLANNING_PLANNING_LOCATION).add(PLANNING_PLANNING_LOCATION_DELETE);
        hierarchy.get(RH_GESTION_RECRUTEMENT).add(RH_GESTION_RECRUTEMENT_CANDIDATURE_CHAUFFEUR);
        hierarchy.get(RH_GESTION_RECRUTEMENT).add(RH_GESTION_RECRUTEMENT_CANDIDATURE_SEDENTAIRE);
        hierarchy.get(RH_GESTION_RECRUTEMENT).add(RH_GESTION_RECRUTEMENT_BESOINS_RECRUTEMENT);
        hierarchy.get(RH_GESTION_DE_SALARIES).add(RH_GESTION_DE_SALARIES_READ);
        hierarchy.get(RH_GESTION_DE_SALARIES).add(RH_GESTION_DE_SALARIES_WRITE);
        hierarchy.get(RH_GESTION_DE_SALARIES).add(RH_GESTION_DE_SALARIES_MODIFY);
        hierarchy.get(RH_GESTION_DE_SALARIES).add(RH_GESTION_DE_SALARIES_DELETE);
        hierarchy.get(RH_GESTION_DE_CALENDRIER).add(RH_GESTION_DE_CALENDRIER_READ);
        hierarchy.get(RH_GESTION_DE_CALENDRIER).add(RH_GESTION_DE_CALENDRIER_WRITE);
        hierarchy.get(RH_GESTION_DE_CALENDRIER).add(RH_GESTION_DE_CALENDRIER_MODIFY);
        hierarchy.get(RH_GESTION_DE_CALENDRIER).add(RH_GESTION_DE_CALENDRIER_DELETE);
        hierarchy.get(RH_RDV_ANNUEL).add(RH_RDV_ANNUEL_READ);
        hierarchy.get(RH_RDV_ANNUEL).add(RH_RDV_ANNUEL_WRITE);
        hierarchy.get(RH_RDV_ANNUEL).add(RH_RDV_ANNUEL_MODIFY);
        hierarchy.get(RH_RDV_ANNUEL).add(RH_RDV_ANNUEL_DELETE);
        hierarchy.get(RH_GESTION_ABSENCE).add(RH_GESTION_ABSENCE_READ);
        hierarchy.get(RH_GESTION_ABSENCE).add(RH_GESTION_ABSENCE_WRITE);
        hierarchy.get(RH_GESTION_ABSENCE).add(RH_GESTION_ABSENCE_MODIFY);
        hierarchy.get(RH_GESTION_ABSENCE).add(RH_GESTION_ABSENCE_DELETE);
        hierarchy.get(RH_GESTION_DE_CONGE).add(RH_GESTION_DE_CONGE_READ);
        hierarchy.get(RH_GESTION_DE_CONGE).add(RH_GESTION_DE_CONGE_WRITE);
        hierarchy.get(RH_GESTION_DE_CONGE).add(RH_GESTION_DE_CONGE_MODIFY);
        hierarchy.get(RH_GESTION_DE_CONGE).add(RH_GESTION_DE_CONGE_DELETE);
        hierarchy.get(RH_DOCUMENT).add(RH_DOCUMENT_READ);
        hierarchy.get(RH_DOCUMENT).add(RH_DOCUMENT_WRITE);
        hierarchy.get(RH_DOCUMENT).add(RH_DOCUMENT_MODIFY);
        hierarchy.get(RH_DOCUMENT).add(RH_DOCUMENT_DELETE);
        hierarchy.get(STAFF_GESTION_DOCUMENTS).add(STAFF_GESTION_DOCUMENTS_READ);
        hierarchy.get(STAFF_GESTION_DOCUMENTS).add(STAFF_GESTION_DOCUMENTS_WRITE);
        hierarchy.get(STAFF_GESTION_DOCUMENTS).add(STAFF_GESTION_DOCUMENTS_MODIFY);
        hierarchy.get(STAFF_GESTION_DOCUMENTS).add(STAFF_GESTION_DOCUMENTS_DELETE);
    }

    public static Set<Permission> getAllDerivedPermissions(Collection<Permission> perms) {
        Set<Permission> result = new LinkedHashSet<>();
        perms.forEach(p -> traverse(p, result));
        return result;
    }

    private static void traverse(Permission p, Set<Permission> seen) {
        if (!seen.add(p)) return;
        hierarchy.get(p).forEach(c -> traverse(c, seen));
        implications.get(p).forEach(c -> traverse(c, seen));
    }
}
