package com.marketingconfort.adanev.vsn.user.models;

import com.marketingconfort.adanev.vsn.user.enums.MainBranch;
import com.marketingconfort.adanev.vsn.user.enums.PortalAssignment;
import jakarta.persistence.*;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import java.time.LocalDateTime;

@Entity
@Getter
@Setter
@NoArgsConstructor
@AllArgsConstructor
@PrimaryKeyJoinColumn(name = "user_id")
public class Client extends User {

    private String landlinePhone;

    @Enumerated(EnumType.STRING)
    private MainBranch mainBranch;

    @Enumerated(EnumType.STRING)
    private PortalAssignment portalAssignment;

    private LocalDateTime signatureDate;

    private String colorCode;

    private String siret;

    private String tva;

    private long agency_id;

    private long ape_code;

    private LocalDateTime paymentDate;

    private String observation;

    private String bankName;

    private String iban;

    private String auxiliaryAccount;

    private String salesAccount;

    private String accountingAccount;

    private String accountHolder;

    private String accountAddress;

    private String swiftBic;

    @ManyToOne
    @JoinColumn(name = "client_type_id")
    private ClientType clientType;


}

