package com.marketingconfort.adanev.vsn.user.models;

import com.marketingconfort.adanev.vsn.user.enums.CollaboratorStatus;
import com.marketingconfort.adanev.vsn.user.enums.ContractType;
import com.marketingconfort.adanev.vsn.user.enums.UserStatus;
import jakarta.persistence.*;
import jakarta.validation.constraints.NotNull;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import java.util.Date;

@Entity
@Getter
@Setter
@NoArgsConstructor
@AllArgsConstructor
@PrimaryKeyJoinColumn(name="user_id")
public class Collaborator extends User {

    @Column(name = "agent_identifier", nullable = false)
    private String agentIdentifier;

    @Column(name = "department_id", nullable = false)
    private Long departmentId;

    @Column(name = "agency_id", nullable = false)
    private Long agencyId;

    @ManyToOne
    @JoinColumn(name = "team_id")
    private Team team;

    @Enumerated(EnumType.STRING)
    @Column(name = "contract_type", nullable = false)
    private ContractType contractType;

    @Column(name = "social_security_number", nullable = false)
    private String socialSecurityNumber;

    @Enumerated(EnumType.STRING)
    @Column(name = "collaborator_status")
    private CollaboratorStatus collaboratorStatus;

    @Column(name = "folder_id")
    private Long folderId;
}