package com.marketingconfort.adanev.vsn.user.models;

import com.marketingconfort.adanev.vsn.core.models.BaseEntity;
import jakarta.persistence.*;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import java.util.List;

@Entity
@Getter
@Setter
@NoArgsConstructor
@AllArgsConstructor
public class Contact extends BaseEntity {
    @ElementCollection(fetch = FetchType.LAZY)
    @CollectionTable(name = "contact_landline_phones", joinColumns = @JoinColumn(name = "contact_id"))
    private List<String> landlinePhones;

    @ElementCollection(fetch = FetchType.LAZY)
    @CollectionTable(name = "contact_mobile_phones", joinColumns = @JoinColumn(name = "contact_id"))
    private List<String> mobilePhones;

    @ElementCollection(fetch = FetchType.LAZY)
    @CollectionTable(name = "contact_assigned_persons", joinColumns = @JoinColumn(name = "contact_id"))
    private List<String> assignedPersons;

    @ManyToOne
    @JoinColumn(name = "representative_id", nullable = false)
    private Representative representative;
}
