package com.marketingconfort.adanev.vsn.user.models;

import com.marketingconfort.adanev.vsn.circuit.enums.DaysOfWeek;
import com.marketingconfort.adanev.vsn.circuit.enums.SensTrip;
import com.marketingconfort.adanev.vsn.circuit.enums.WeekType;
import com.marketingconfort.adanev.vsn.core.models.BaseEntity;
import jakarta.persistence.*;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import java.util.List;

@Entity
@Getter
@Setter
@NoArgsConstructor
@AllArgsConstructor
public class DaySchedule extends BaseEntity {

    @Enumerated(EnumType.STRING)
    private DaysOfWeek dayOfWeek;

    @Enumerated(EnumType.STRING)
    private SensTrip sens;
    @ManyToMany(mappedBy = "daySchedules")
    private List<TransportSchedule> transportSchedules;
}
