package com.marketingconfort.adanev.vsn.user.models;


import com.marketingconfort.adanev.vsn.user.enums.DriverStatus;
import jakarta.persistence.*;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import java.time.LocalDateTime;
import java.util.List;

@Entity
@Getter
@Setter
@NoArgsConstructor
@AllArgsConstructor
@PrimaryKeyJoinColumn(name="user_id")
public class Driver extends User {

    private LocalDateTime entryDate;
    private String documentPath;
    private String residenceCardTitle;
    private String residencePermitOrIDCard;
    private String socialSecurityNumber;
    private long vehicleIds;
    @Enumerated(EnumType.STRING)
    private DriverStatus driverStatus;

    @ElementCollection(fetch = FetchType.EAGER)
    private List<Long> fuelCardIds;

    private long drivingLicenseId;

    @ElementCollection(fetch = FetchType.EAGER)
    private List<String> circuitsId;

    @ElementCollection(fetch = FetchType.EAGER)
    private List<Long> absenceIds;

    private Long sectorId;
    private Long agency;
    private Long departmentId;

}
