package com.marketingconfort.adanev.vsn.user.models;

import jakarta.persistence.Entity;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.OneToOne;
import jakarta.persistence.PrimaryKeyJoinColumn;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

@Entity
@PrimaryKeyJoinColumn(name = "passenger_representative_id")
@Getter
@Setter
@NoArgsConstructor
@AllArgsConstructor
public class Interlocutor extends PassengerRepresentative {
    private String observations;
    private String mobilePhone;

    @OneToOne
    @JoinColumn(name = "passenger_id")
    private Passenger passenger;
}
