package com.marketingconfort.adanev.vsn.user.models;

import com.marketingconfort.adanev.vsn.user.enums.CustodyCategory;
import com.marketingconfort.adanev.vsn.user.enums.ParticularityTransport;
import com.marketingconfort.adanev.vsn.user.enums.SchoolClass;
import com.marketingconfort.adanev.vsn.user.enums.State;
import jakarta.persistence.*;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import java.time.LocalDateTime;
import java.util.List;

@Entity
@PrimaryKeyJoinColumn(name = "user_id")
@Getter
@Setter
@NoArgsConstructor
@AllArgsConstructor
public class Passenger extends User {
    private LocalDateTime openingDays;
    private String observations;
    private LocalDateTime startTransport;
    private String specificity;
    private String referentTeacherName;

    @Enumerated(EnumType.STRING)
    private CustodyCategory custodyCategory;

    @Enumerated(EnumType.STRING)
    private ParticularityTransport particularityTransport;

    @Enumerated(EnumType.STRING)
    private State state;
    private Long idEstablishment;
    @Enumerated(EnumType.STRING)
    private SchoolClass schoolClass;
    @OneToMany(mappedBy = "passenger")
    private List<Representative> representatives;
    private Long idDepartment;
    @OneToOne(mappedBy = "passenger")
    private Interlocutor interlocutor;



}
