package com.marketingconfort.adanev.vsn.user.models;

import com.marketingconfort.adanev.vsn.core.enums.Civility;
import com.marketingconfort.adanev.vsn.core.models.BaseEntity;
import com.marketingconfort.adanev.vsn.user.enums.RelationType;
import jakarta.persistence.*;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

@MappedSuperclass
@Getter
@Setter
@NoArgsConstructor
@AllArgsConstructor
public abstract class PassengerRepresentative extends BaseEntity {
    private String firstName;
    private String lastName;
    @Column(unique = true, nullable = false)
    private String email;
    @Enumerated(EnumType.STRING)
    private Civility civility;

    @Enumerated(EnumType.STRING)
    private RelationType type;


}
