package com.marketingconfort.adanev.vsn.user.models;

import jakarta.persistence.*;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import java.util.List;

@Entity
@PrimaryKeyJoinColumn(name = "passenger_representative_id")
@Getter
@Setter
@NoArgsConstructor
@AllArgsConstructor
public class Representative extends PassengerRepresentative {
    private boolean parentalAuthorization;
    private boolean arrivalNotification;
    private String idCircuit;
    @OneToMany(mappedBy = "representative")
    private List<Contact> contacts;

    @OneToMany(mappedBy = "representative")
    private List<Address> addresses;
    @ManyToOne
    @JoinColumn(name = "passenger_id", nullable = false)
    private Passenger passenger;

    @OneToMany(mappedBy = "responsibleRepresentative")
    private List<TransportSchedule> transportSchedules;

}
