package com.marketingconfort.adanev.vsn.user.models;

import com.marketingconfort.adanev.vsn.core.models.BaseEntity;
import com.marketingconfort.adanev.vsn.user.enums.Permission;
import com.marketingconfort.adanev.vsn.user.enums.RoleStatus;
import jakarta.persistence.*;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import java.util.List;

@Entity
@Getter
@Setter
@NoArgsConstructor
@AllArgsConstructor
public class Roles extends BaseEntity {

    @Column(unique = true, nullable = false)
    private String name;
    private String description;
    @Enumerated(EnumType.STRING)
    private RoleStatus status;

    @ManyToMany(mappedBy = "roles")
    private List<User> users;

    @ElementCollection(fetch = FetchType.LAZY)
    @CollectionTable(name = "role_permissions", joinColumns = @JoinColumn(name = "role_id"))
    @Enumerated(EnumType.STRING)
    @Column(name = "permission")
    private List<Permission> permissions;
}
