package com.marketingconfort.adanev.vsn.user.models;

import com.marketingconfort.adanev.vsn.core.models.BaseEntity;
import com.marketingconfort.adanev.vsn.user.enums.TeamStatus;
import jakarta.persistence.*;
import jakarta.validation.constraints.NotNull;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import java.time.LocalDate;
import java.util.List;

@Entity
@Getter
@Setter
@NoArgsConstructor
@AllArgsConstructor
@Table(name = "teams")
public class Team extends BaseEntity {

    @Column(unique = true, nullable = false)
    private String teamCode;
    @NotNull
    private String name;
    @ManyToOne
    @JoinColumn(name = "team_leader_id")
    private Collaborator teamLeader;
    @Column(name = "department_id")
    private Long departmentId;
    private LocalDate creationDate;
    @Enumerated(EnumType.STRING)
    private TeamStatus status;
    @OneToMany(mappedBy = "team")
    private List<Collaborator> collaborators;

}