package com.marketingconfort.adanev.vsn.user.models;

import com.marketingconfort.adanev.vsn.circuit.enums.WeekType;
import com.marketingconfort.adanev.vsn.core.models.BaseEntity;
import jakarta.persistence.*;
import lombok.*;

import java.util.List;

@Entity
@Getter
@Setter
@NoArgsConstructor
@AllArgsConstructor
public class TransportSchedule extends BaseEntity {

    @Enumerated(EnumType.STRING)
    private WeekType weekType;

    @ManyToMany
    @JoinTable(
            name = "transport_schedule_day_schedule",
            joinColumns = @JoinColumn(name = "transport_schedule_id"),
            inverseJoinColumns = @JoinColumn(name = "day_schedule_id")
    )
    private List<DaySchedule> daySchedules;

    @ManyToOne
    @JoinColumn(name = "representative_id", nullable = false)
    private Representative responsibleRepresentative;
}
