package com.marketingconfort.adanev.vsn.user.models;

import com.marketingconfort.adanev.vsn.core.enums.Civility;
import com.marketingconfort.adanev.vsn.core.models.BaseEntity;
import com.marketingconfort.adanev.vsn.user.enums.UserStatus;
import jakarta.persistence.*;
import jakarta.validation.constraints.NotNull;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;

@Entity
@Getter
@Setter
@NoArgsConstructor
@AllArgsConstructor
@Table(name = "users")
@Inheritance(strategy = InheritanceType.JOINED)
public class User extends BaseEntity {
    @NotNull
    private String lastName;
    @NotNull
    private String firstName;
    @Column(unique = true, nullable = false)
    private String email;
    @Column(name = "personal_email")
    private String personalEmail;
    private LocalDateTime birthDate;
    private String birthPlace;
    @Enumerated(EnumType.STRING)
    private Civility civility;
    private String phoneNumber;
    @Enumerated(EnumType.STRING)
    private UserStatus UserStatus;
    private String photoUrl;
    private boolean isArchived;

    // Storage quota attributes
    @Column(name = "storage_quota")
    private Long storageQuota;

    @Column(name = "used_storage_quota")
    private Long usedStorageQuota;

    @OneToMany(mappedBy = "user", fetch = FetchType.EAGER)
    private List<Address> addresses;


    @ManyToMany(fetch = FetchType.EAGER)
    @JoinTable(
            name = "user_roles",
            joinColumns = @JoinColumn(name = "user_id"),
            inverseJoinColumns = @JoinColumn(name = "role_id")
    )
    private List<Roles> roles;


    @OneToMany(mappedBy = "user", cascade = CascadeType.ALL, orphanRemoval = true)
    private List<UserConnectionHistory> connectionHistory;

}
