package com.marketingconfort.adanev.vsn.user.models;

import com.marketingconfort.adanev.vsn.core.models.BaseEntity;
import jakarta.persistence.*;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import java.time.Duration;
import java.time.LocalDateTime;

@Entity
@Getter
@Setter
@NoArgsConstructor
@AllArgsConstructor
@Table(name = "user_connection_history")
public class UserConnectionHistory extends BaseEntity {

    @ManyToOne(fetch = FetchType.LAZY)
    @JoinColumn(name = "user_id", nullable = false)
    private User user;

    @Column(name = "login_datetime", nullable = false)
    private LocalDateTime loginDateTime;

    @Column(name = "logout_datetime")
    private LocalDateTime logoutDateTime;

    @Column(name = "duration")
    private Long duration;

    @PrePersist
    @PreUpdate
    public void calculateDuration() {
        if (loginDateTime != null && logoutDateTime != null) {
            this.duration = Duration.between(loginDateTime, logoutDateTime).getSeconds();
        }
    }
}