package com.marketingconfort.adanev.vsn.document.constants.paths;

public class Paths {

    public static final String BASE_URL = "/api/document";
    public static final String DOWNLOAD_ELEMENT = "/download";
    //Folder management urls
    public static final String FOLDER_BASE = BASE_URL + "/folders";
    public static final String ADD_FOLDER = "/create";
    public static final String RENAME_FOLDER = "/rename/{folderId}";
    public static final String DELETE_FOLDER = "/delete/{folderId}";
    public static final String MOVE_FOLDER = "/move/{folderId}";
    public static final String ROOT_FOLDERS = "/root/{ownerId}";
    public static final String SUB_FOLDERS = "/subfolders/{parentId}";
    public static final String FOLDER_DOCS = "/documents/{parentId}";
    public static final String FOLDERS_SEARCH = "/search";
    public static final String FOLDER_DETAILS = "/details/{folderId}";
    public static final String FOLDER_ADVANCED_SEARCH = "/search-paged";
    public static final String FOLDER_SHARE = "/share";
    public static final String FOLDER_CANCEL_SHARE = "/{folderId}/unshare/{userId}";
    public static final String FOLDER_ZIP = "/zip/{folderId}";
    public static final String FOLDER_SIZE = "/size/{folderId}";
    public static final String FOLDER_FAVORITE = "/favorite/{folderId}";
    public static final String FOLDER_CLEAN_FAVORITE = "/cancel-favorite/{folderId}";
    public static final String FAVORITES = "/favorites/{ownerId}";
    public static final String BULK_DELETE = "/bulk/delete";
    public static final String BULK_MOVE = "/bulk/move";
    public static final String BULK_SHARE = "/bulk/share";

    // Storage management urls
    public static final String STORAGE_BASE = BASE_URL + "/storage";
    public static final String STORAGE_QUOTA_INFO = "/quota/{ownerId}";
    public static final String STORAGE_CHECK_AVAILABLE = "/quota/{ownerId}/check";
    public static final String STORAGE_USAGE_PERCENTAGE = "/quota/{ownerId}/percentage";
    public static final String STORAGE_QUOTA_EXCEEDED = "/quota/{ownerId}/exceeded";
    public static final String STORAGE_TOTAL_USED = "/quota/{ownerId}/used";
    public static final String STORAGE_AVAILABLE = "/quota/{ownerId}/available";

    //document management urls
    public static final String DOCUMENT_BASE = BASE_URL + "/docs";
    public static final String DOCUMENT_UPLOAD = "/upload";
    public static final String USER_DOCUMENTS = "/all";
    public static final String DOCUMENT_DETAILS = "/details";
    public static final String ROOT_DOCUMENTS = "/root";
    public static final String DOCUMENT_STATS = "/stats";
    public static final String SEARCH_DOCUMENTS = "/search";
    public static final String SEARCH_DOCUMENTS_ADVANCED = "/search-advanced";
    public static final String DELETE_DOCUMENT = "/delete";
    public static final String BULK_DELETE_DOCUMENTS = "/bulk-delete";
    public static final String GET_DOWNLOAD_URL = "/get-download-url";
    public static final String DOCUMENT_SHARE = "/share";
    public static final String BULK_SHARE_DOCUMENTS = "/bulk-share";
    public static final String MARK_DOC_AS_FAVORITE = "/favorite/{documentId}";
    public static final String UNMARK_DOC_AS_FAVORITE = "/cancel-favorite/{documentId}";
    public static final String FAVORITE_DOCS = "/favorites";
    public static final String MOVE_DOCUMENT = "/move/{documentId}";
    public static final String BULK_MOVE_DOCUMENTS = "/bulk-move";

}
