package com.marketingconfort.adanev.vsn.document.controller;

import com.marketingconfort.adanev.vsn.document.constants.paths.Paths;
import com.marketingconfort.adanev.vsn.document.dtos.StorageQuotaInfoDTO;
import com.marketingconfort.adanev.vsn.document.services.StorageQuotaService;
import com.marketingconfort.starter.core.exceptions.FunctionalException;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

@RestController
@RequestMapping(Paths.STORAGE_BASE)
@RequiredArgsConstructor
@Slf4j
public class StorageQuotaController {

    private final StorageQuotaService storageQuotaService;

    @GetMapping(Paths.STORAGE_QUOTA_INFO)
    public ResponseEntity<StorageQuotaInfoDTO> getStorageQuotaInfo(@PathVariable Long ownerId) {
        try {
            StorageQuotaInfoDTO quotaInfo = storageQuotaService.getStorageQuotaInfo(ownerId);
            return ResponseEntity.ok(quotaInfo);
        } catch (FunctionalException e) {
            return ResponseEntity.badRequest().build();
        }
    }


    @GetMapping(Paths.STORAGE_CHECK_AVAILABLE)
    public ResponseEntity<Boolean> checkAvailableStorage(
            @PathVariable Long ownerId,
            @RequestParam Long additionalSizeBytes) {
        try {
            boolean hasSpace = storageQuotaService.hasAvailableStorage(ownerId, additionalSizeBytes);
            return ResponseEntity.ok(hasSpace);
        } catch (FunctionalException e) {
            return ResponseEntity.badRequest().build();
        }
    }

    @GetMapping(Paths.STORAGE_USAGE_PERCENTAGE)
    public ResponseEntity<Double> getStorageUsagePercentage(@PathVariable Long ownerId) {
        try {
            double percentage = storageQuotaService.getStorageUsagePercentage(ownerId);
            return ResponseEntity.ok(percentage);
        } catch (FunctionalException e) {
            return ResponseEntity.badRequest().build();
        }
    }

    @GetMapping(Paths.STORAGE_QUOTA_EXCEEDED)
    public ResponseEntity<Boolean> isStorageQuotaExceeded(@PathVariable Long ownerId) {
        try {
            boolean exceeded = storageQuotaService.isStorageQuotaExceeded(ownerId);
            return ResponseEntity.ok(exceeded);
        } catch (FunctionalException e) {
            return ResponseEntity.badRequest().build();
        }
    }

    @GetMapping(Paths.STORAGE_TOTAL_USED)
    public ResponseEntity<Long> getTotalUsedStorage(@PathVariable Long ownerId) {
        try {
            Long usedStorage = storageQuotaService.getTotalUsedStorage(ownerId);
            return ResponseEntity.ok(usedStorage);
        } catch (FunctionalException e) {
            return ResponseEntity.badRequest().build();
        }
    }

    @GetMapping(Paths.STORAGE_AVAILABLE)
    public ResponseEntity<Long> getAvailableStorage(@PathVariable Long ownerId) {
        try {
            Long availableStorage = storageQuotaService.getAvailableStorage(ownerId);
            return ResponseEntity.ok(availableStorage);
        } catch (FunctionalException e) {
            return ResponseEntity.badRequest().build();
        }
    }
}
