package com.marketingconfort.adanev.vsn.document.dtos;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.time.LocalDateTime;

@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class StorageQuotaInfoDTO {

    // Owner Information
    private Long ownerId;

    // Storage Quota Information (Constant 15 MB)
    private Long storageQuotaBytes;
    private String storageQuotaFormatted;

    // Used Storage Information (Calculated from folders)
    private Long usedStorageBytes;
    private String usedStorageFormatted;

    // Available Storage Information
    private Long availableStorageBytes;
    private String availableStorageFormatted;

    // Usage Statistics
    private Double usagePercentage;
    private Boolean isQuotaExceeded;

    // Additional Information
    private Integer totalFolders;
    private LocalDateTime lastCalculated;

    // Convenience methods
    public String getUsageStatus() {
        if (isQuotaExceeded) {
            return "EXCEEDED";
        } else if (usagePercentage >= 90) {
            return "CRITICAL";
        } else if (usagePercentage >= 75) {
            return "WARNING";
        } else if (usagePercentage >= 50) {
            return "MODERATE";
        } else {
            return "NORMAL";
        }
    }

    public String getUsageColor() {
        String status = getUsageStatus();
        return switch (status) {
            case "EXCEEDED" -> "#FF0000"; // Red
            case "CRITICAL" -> "#FF6600"; // Orange
            case "WARNING" -> "#FFCC00";  // Yellow
            case "MODERATE" -> "#3399FF"; // Blue
            default -> "#00CC66";         // Green
        };
    }

    public String getUsageDescription() {
        return String.format("Using %s of %s (%s%%)",
                usedStorageFormatted,
                storageQuotaFormatted,
                usagePercentage);
    }
}
