package com.marketingconfort.adanev.vsn.document.repositories;

import com.marketingconfort.adanev.vsn.document.models.Document;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Optional;

@Repository
public interface DocumentRepository extends JpaRepository<Document, Long> , JpaSpecificationExecutor<Document> {
    List<Document> findByFolderIdAndOwnerId(Long folderId, Long ownerId);


    boolean existsByNameAndFolderIsNullAndOwnerId(String name, Long ownerId);

    boolean existsByNameAndFolderIdAndOwnerId(String name, Long folderId, Long ownerId);

    List<Document> findByOwnerIdAndFolderIsNull(Long ownerId);

    List<Document> findByOwnerId(Long ownerId);

    Optional<Document> findByIdAndOwnerId(Long documentId, Long ownerId);
    @Query("SELECT d FROM Document d LEFT JOIN d.folder f " +
            "WHERE d.ownerId = :ownerId " +
            "AND (:keyword IS NULL OR LOWER(d.name) LIKE LOWER(CONCAT('%', :keyword, '%')))")
    List<Document> searchDocuments(
            @Param("ownerId") Long ownerId,
            @Param("keyword") String keyword,
            Sort sort
    );
    List<Document> findByOwnerIdAndFavoriteTrue(Long ownerId);

}
