package com.marketingconfort.adanev.vsn.document.repositories;

import com.marketingconfort.adanev.vsn.document.dtos.FolderDTO;
import com.marketingconfort.adanev.vsn.document.models.Folder;
import org.springframework.data.domain.Page;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;
import org.springframework.data.domain.Pageable;
import java.util.List;
import java.util.Optional;

@Repository
public interface FolderRepository extends JpaRepository<Folder, Long>, JpaSpecificationExecutor<Folder> {

    boolean existsByNameAndOwnerIdAndParent(String name, Long ownerId, Folder parent);
    List<Folder> findByOwnerIdAndParentIsNull(Long ownerId);
    List<Folder> findByParentIdAndOwnerId(Long parentId, Long ownerId);
    @Query("SELECT DISTINCT f FROM Folder f " +
            "LEFT JOIN f.documents d " +
            "WHERE LOWER(f.name) LIKE %:keyword% " +
            "   OR LOWER(d.name) LIKE %:keyword%")
    Page<Folder> searchFoldersByKeyword(@Param("keyword") String keyword, Pageable pageable);

    Optional<Folder> findByNameAndOwnerId(String name, Long ownerId);
    List<Folder> findByOwnerId(Long ownerId);
    List<Folder> findByOwnerIdAndFavoriteTrue(Long ownerId);

    @Query("SELECT f FROM Folder f LEFT JOIN f.documents d " +
            "WHERE f.ownerId = :ownerId AND " +
            "(LOWER(f.name) LIKE %:keyword% OR LOWER(d.name) LIKE %:keyword%)")
    Page<Folder> searchFoldersByKeywordAndOwnerId(@Param("keyword") String keyword,
                                                  @Param("ownerId") Long ownerId,
                                                  Pageable pageable);

    Optional<Folder> findByOwnerIdAndName(Long targetUserId, String sharedWithMe);
}
