package com.marketingconfort.adanev.vsn.document.services;

import com.marketingconfort.adanev.vsn.document.dtos.DocumentDTO;
import com.marketingconfort.adanev.vsn.document.dtos.FolderDTO;
import com.marketingconfort.adanev.vsn.document.dtos.requests.NewFolderRequest;
import com.marketingconfort.adanev.vsn.document.dtos.requests.ShareFolderRequest;
import com.marketingconfort.adanev.vsn.document.dtos.response.FolderDetailsResponse;
import com.marketingconfort.adanev.vsn.document.dtos.response.FolderSizeResponseDTO;
import com.marketingconfort.starter.core.exceptions.FunctionalException;
import org.springframework.data.domain.Page;
import org.springframework.http.ResponseEntity;

import java.io.IOException;
import java.util.List;

public interface FolderService {
    FolderDTO createFolder(NewFolderRequest request) throws FunctionalException;
    FolderDTO renameFolder(Long id, String newName, Long ownerId) throws FunctionalException;
    void deleteFolderById(Long folderId, Long ownerId) throws FunctionalException;
    FolderDTO moveFolder(Long folderId, Long newParentId, Long ownerId) throws FunctionalException;
    List<FolderDTO> listRootFolders(Long ownerId);
    List<FolderDTO> listSubFolders(Long parentId, Long ownerId);
    List<DocumentDTO> listDocumentsInFolder(Long folderId, Long ownerId);
    List<FolderDTO> searchFolders(String keyword, Long ownerId);
    FolderDetailsResponse getFolderDetails(Long folderId) throws FunctionalException;
    Page<FolderDTO> advancedSearchFolders(String keyword, Long ownerId, int page, int size, String sortBy, String sortDirection) throws FunctionalException;
    void shareFolderWithUsers(ShareFolderRequest request) throws FunctionalException;
    void unshareFolderWithUser(Long folderId, Long userId) throws FunctionalException;
    byte[] zipFolderAndReturn(Long folderId) throws FunctionalException;
    ResponseEntity<byte[]> downloadZippedFolder(Long folderId) throws FunctionalException;
    FolderSizeResponseDTO calculateFolderSize(Long folderId) throws FunctionalException;
    void markFolderAsFavorite(Long folderId, Long userId) throws FunctionalException;
    void unmarkFolderAsFavorite(Long folderId, Long userId) throws FunctionalException;
    List<FolderDTO> getFavoriteFolders(Long userId);
    void bulkDelete(List<Long> folderIds, Long ownerId) throws FunctionalException;
    void bulkShare(List<Long> folderIds, List<Long> userIds) throws FunctionalException;
    void bulkMove(List<Long> folderIds, Long newParentId, Long ownerId) throws FunctionalException;
}
