package com.marketingconfort.adanev.vsn.document.utils;

import com.marketingconfort.adanev.vsn.document.constants.MessageConstants;
import com.marketingconfort.adanev.vsn.document.models.Document;
import com.marketingconfort.adanev.vsn.document.models.Folder;

import com.marketingconfort.adanev.vsn.document.enums.ContentType;
import com.marketingconfort.starter.core.exceptions.FunctionalException;
import org.springframework.web.multipart.MultipartFile;


public class DocumentUtils {

    public static String constructDocumentPath(String documentName, Folder parentFolder) {
        if (parentFolder == null) {
            return "/" + documentName;
        }

        return buildFolderPath(parentFolder) + "/" + documentName;
    }

    public static String buildFolderPath(Folder folder) {
        if (folder == null) return "";
        if (folder.getParent() == null) {
            return folder.getName(); // racine
        }
        return buildFolderPath(folder.getParent()) + "/" + folder.getName(); // récursion
    }

    public static String constructS3Key(MultipartFile file, Long userId, Folder folder) {
        StringBuilder s3Key = new StringBuilder("document_service_folder/");
        s3Key.append(userId).append("/");

        if (folder != null) {
            s3Key.append(buildFolderPath(folder)).append("/");
        }

        return s3Key.toString();
    }
    public static String constructS3KeyForMove(Document doc, Long ownerId, Folder newFolder) {
        StringBuilder s3Key = new StringBuilder("document_service_folder/");
        s3Key.append(ownerId).append("/");

        if (newFolder != null) {
            s3Key.append(newFolder.getName()).append("/");
        }

        s3Key.append(doc.getName());
        return s3Key.toString();
    }



    public static ContentType detectContentType(MultipartFile file) throws FunctionalException {
        if (file == null || file.getOriginalFilename() == null) {
            throw new FunctionalException(MessageConstants.INVALID_FILE);
        }

        String contentType = file.getContentType();
        String filename = file.getOriginalFilename().toLowerCase();

        if (contentType != null) {
            if (contentType.startsWith("image/")) {
                return ContentType.IMAGE;
            } else if (contentType.equals("application/pdf")) {
                return ContentType.PDF;
            } else if (isWordMime(contentType)) {
                return ContentType.WORD;
            } else if (isExcelMime(contentType)) {
                return ContentType.EXCEL;
            }
        }

        // Fallback based on file extension
        if (filename.endsWith(".pdf")) return ContentType.PDF;
        if (filename.endsWith(".jpg") || filename.endsWith(".jpeg") || filename.endsWith(".png")) return ContentType.IMAGE;
        if (filename.endsWith(".doc") || filename.endsWith(".docx")) return ContentType.WORD;
        if (filename.endsWith(".xls") || filename.endsWith(".xlsx")) return ContentType.EXCEL;

        throw new FunctionalException(MessageConstants.INVALID_FILE_TYPE + filename);
    }

    private static boolean isWordMime(String mimeType) {
        return mimeType.equals("application/msword") ||
                mimeType.equals(MessageConstants.WORD_MIME);
    }

    private static boolean isExcelMime(String mimeType) {
        return mimeType.equals("application/vnd.ms-excel") ||
                mimeType.equals(MessageConstants.EXCEL_MIME);
    }
}
