package com.marketingconfort.adanev.vsn.document.utils;

import com.marketingconfort.adanev.vsn.document.constants.MessageConstants;
import com.marketingconfort.adanev.vsn.document.dtos.requests.NewFolderRequest;
import com.marketingconfort.adanev.vsn.document.models.Document;
import com.marketingconfort.adanev.vsn.document.models.Folder;
import com.marketingconfort.adanev.vsn.document.repositories.DocumentRepository;
import com.marketingconfort.adanev.vsn.document.repositories.FolderRepository;
import com.marketingconfort.starter.core.exceptions.FunctionalException;
import lombok.RequiredArgsConstructor;
import org.springframework.util.StreamUtils;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;


public class FolderUtils {


    public static void addToZip(String entryName, String filePath, ZipOutputStream zipOut) throws IOException, FunctionalException {
        Path path = Paths.get(filePath);

        if (!Files.exists(path)) {
            throw new FunctionalException("File not found: " + filePath);
        }

        zipOut.putNextEntry(new ZipEntry(entryName));
        try (InputStream inputStream = Files.newInputStream(path)) {
            StreamUtils.copy(inputStream, zipOut);
        }
        zipOut.closeEntry();
    }

    public static void addFolderToZip(Folder folder, String rootFolderPath, ZipOutputStream zipOut) throws IOException, FunctionalException {
        List<Document> documents = folder.getDocuments();
        List<Folder> subFolders = folder.getSubFolders();

        for (Document document : documents) {
            addToZip(rootFolderPath + "/" + folder.getName() + "/" + document.getName(), document.getPath(), zipOut);
        }

        for (Folder subFolder : subFolders) {
            addFolderToZip(subFolder, rootFolderPath + "/" + folder.getName(), zipOut);
        }
    }

    FolderUtils() {}


}
