package com.marketingconfort.adanev.vsn.document;

import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.domain.EntityScan;
import org.springframework.boot.autoconfigure.security.servlet.SecurityAutoConfiguration;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;

@SpringBootApplication(exclude = {SecurityAutoConfiguration.class})
@ComponentScan(basePackages = {
        "com.marketingconfort.starter.core",
        "com.marketingconfort.adanev.vsn"
})
@EnableJpaRepositories(basePackages = {
        "com.marketingconfort.starter.core.models",
        "com.marketingconfort.adanev.vsn.document.repositories"
})
@EntityScan(basePackages = {
        "com.marketingconfort.starter.core",
        "com.marketingconfort.adanev.vsn.common.user.models",
        "com.marketingconfort.adanev.vsn.document.models"

})
public class VsnDocumentServiceApplication {

    public static void main(String[] args) {
        SpringApplication.run(VsnDocumentServiceApplication.class, args);
    }

}
