package com.marketingconfort.adanev.vsn.document.config;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;

public class AWSConfig {
    private static AWSConfig instance = null;
    private static final String accessKey = EnvConfigLoader.getEnvironmentConfig().getAws().getAccessKey();
    private static final String secretKey = EnvConfigLoader.getEnvironmentConfig().getAws().getSecretKey();
    private static final String region = EnvConfigLoader.getEnvironmentConfig().getAws().getRegion();



    public static AWSConfig getInstance() {
        if (instance == null)
            instance = new AWSConfig();
        return instance;
    }

    public AWSCredentials credentials() {
        return new BasicAWSCredentials(
                accessKey,
                secretKey
        );
    }

    public AmazonS3 amazonS3() {
        return AmazonS3ClientBuilder
                .standard()
                .withCredentials(new AWSStaticCredentialsProvider(credentials()))
                .withRegion(region)
                .build();
    }
}
