package com.marketingconfort.adanev.vsn.document.config;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.marketingconfort.adanev.vsn.document.config.props.EnvConfig;
import org.yaml.snakeyaml.Yaml;

import java.io.InputStream;

public class EnvConfigLoader {

    private static final Yaml yaml = new Yaml();

    public static EnvConfig getEnvironmentConfig() {
        InputStream inputStream = EnvConfigLoader.class
                .getClassLoader()
                .getResourceAsStream("application.yml");

        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        return mapper.convertValue(yaml.load(inputStream), EnvConfig.class);
    }

    public static String getEnvProperty(String key) {
        if (key.startsWith("$"))
            return System.getenv().get(
                    key.replace("$", "")
                            .replace("{", "")
                            .replace("}", "")
            );
        return key;
    }
}

