package com.marketingconfort.adanev.vsn.document.dtos.response;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.time.LocalDateTime;

@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class DocumentUploadResponseDTO {

    private Long documentId;
    private String documentName;
    private Long size;
    private String contentType;
    private Long folderId;
    private String folderName;
    private LocalDateTime uploadedAt;
    private String message;

    public String getFormattedSize() {
        if (size == null) return "0 B";

        String[] units = {"B", "KB", "MB", "GB"};
        int unitIndex = 0;
        double fileSize = size;

        while (fileSize >= 1024 && unitIndex < units.length - 1) {
            fileSize /= 1024;
            unitIndex++;
        }

        return String.format("%.1f %s", fileSize, units[unitIndex]);
    }
}
